/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.util.fst;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.fst.FST;

class BitTableUtil {
    BitTableUtil() {
    }

    static boolean isBitSet(int bitIndex, FST.BytesReader reader) throws IOException {
        assert (bitIndex >= 0) : "bitIndex=" + bitIndex;
        reader.skipBytes(bitIndex >> 3);
        return (BitTableUtil.readByte(reader) & 1L << (bitIndex & 7)) != 0L;
    }

    static int countBits(int bitTableBytes, FST.BytesReader reader) throws IOException {
        assert (bitTableBytes >= 0) : "bitTableBytes=" + bitTableBytes;
        int bitCount = 0;
        for (int i = bitTableBytes >> 3; i > 0; --i) {
            bitCount += Long.bitCount(BitTableUtil.read8Bytes(reader));
        }
        int numRemainingBytes = bitTableBytes & 7;
        if (numRemainingBytes != 0) {
            bitCount += Long.bitCount(BitTableUtil.readUpTo8Bytes(numRemainingBytes, reader));
        }
        return bitCount;
    }

    static int countBitsUpTo(int bitIndex, FST.BytesReader reader) throws IOException {
        assert (bitIndex >= 0) : "bitIndex=" + bitIndex;
        int bitCount = 0;
        for (int i = bitIndex >> 6; i > 0; --i) {
            bitCount += Long.bitCount(BitTableUtil.read8Bytes(reader));
        }
        int remainingBits = bitIndex & 0x3F;
        if (remainingBits != 0) {
            int numRemainingBytes = remainingBits + 7 >> 3;
            long mask = (1L << bitIndex) - 1L;
            bitCount += Long.bitCount(BitTableUtil.readUpTo8Bytes(numRemainingBytes, reader) & mask);
        }
        return bitCount;
    }

    static int nextBitSet(int bitIndex, int bitTableBytes, FST.BytesReader reader) throws IOException {
        int i;
        assert (bitIndex >= -1 && bitIndex < bitTableBytes * 8) : "bitIndex=" + bitIndex + " bitTableBytes=" + bitTableBytes;
        int byteIndex = bitIndex / 8;
        int mask = -1 << (bitIndex + 1 & 7);
        if (mask == -1 && bitIndex != -1) {
            reader.skipBytes(byteIndex + 1);
            i = 0;
        } else {
            reader.skipBytes(byteIndex);
            i = reader.readByte() & 0xFF & mask;
        }
        while (i == 0) {
            if (++byteIndex == bitTableBytes) {
                return -1;
            }
            i = reader.readByte() & 0xFF;
        }
        return Integer.numberOfTrailingZeros(i) + (byteIndex << 3);
    }

    static int previousBitSet(int bitIndex, FST.BytesReader reader) throws IOException {
        assert (bitIndex >= 0) : "bitIndex=" + bitIndex;
        int byteIndex = bitIndex >> 3;
        reader.skipBytes(byteIndex);
        int mask = (1 << (bitIndex & 7)) - 1;
        int i = reader.readByte() & 0xFF & mask;
        while (i == 0) {
            if (byteIndex-- == 0) {
                return -1;
            }
            reader.skipBytes(-2L);
            i = reader.readByte() & 0xFF;
        }
        return 31 - Integer.numberOfLeadingZeros(i) + (byteIndex << 3);
    }

    private static long readByte(FST.BytesReader reader) throws IOException {
        return (long)reader.readByte() & 0xFFL;
    }

    private static long readUpTo8Bytes(int numBytes, FST.BytesReader reader) throws IOException {
        assert (numBytes > 0 && numBytes <= 8) : "numBytes=" + numBytes;
        long l = BitTableUtil.readByte(reader);
        int shift = 0;
        while (--numBytes != 0) {
            l |= BitTableUtil.readByte(reader) << (shift += 8);
        }
        return l;
    }

    private static long read8Bytes(FST.BytesReader reader) throws IOException {
        return BitTableUtil.readByte(reader) | BitTableUtil.readByte(reader) << 8 | BitTableUtil.readByte(reader) << 16 | BitTableUtil.readByte(reader) << 24 | BitTableUtil.readByte(reader) << 32 | BitTableUtil.readByte(reader) << 40 | BitTableUtil.readByte(reader) << 48 | BitTableUtil.readByte(reader) << 56;
    }
}

