/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search;

import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.ParsedScrollId;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchPhaseController;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchScrollAsyncAction;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchScrollQueryAndFetchAsyncAction;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchScrollQueryThenFetchAsyncAction;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchScrollRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchTask;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchTransportService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.TransportSearchHelper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.ActionFilters;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.HandledTransportAction;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.inject.Inject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.tasks.Task;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportService;

public class TransportSearchScrollAction
extends HandledTransportAction<SearchScrollRequest, SearchResponse> {
    private final ClusterService clusterService;
    private final SearchTransportService searchTransportService;
    private final SearchPhaseController searchPhaseController;

    @Inject
    public TransportSearchScrollAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, SearchTransportService searchTransportService, SearchPhaseController searchPhaseController) {
        super("indices:data/read/scroll", transportService, actionFilters, SearchScrollRequest::new);
        this.clusterService = clusterService;
        this.searchTransportService = searchTransportService;
        this.searchPhaseController = searchPhaseController;
    }

    @Override
    protected void doExecute(Task task, SearchScrollRequest request, ActionListener<SearchResponse> listener) {
        try {
            SearchScrollAsyncAction action;
            ParsedScrollId scrollId = TransportSearchHelper.parseScrollId(request.scrollId());
            switch (scrollId.getType()) {
                case "queryThenFetch": {
                    action = new SearchScrollQueryThenFetchAsyncAction(this.logger, this.clusterService, this.searchTransportService, this.searchPhaseController, request, (SearchTask)task, scrollId, listener);
                    break;
                }
                case "queryAndFetch": {
                    action = new SearchScrollQueryAndFetchAsyncAction(this.logger, this.clusterService, this.searchTransportService, this.searchPhaseController, request, (SearchTask)task, scrollId, listener);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Scroll id type [" + scrollId.getType() + "] unrecognized");
                }
            }
            action.run();
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

