/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client;

import java.io.IOException;
import java.util.Locale;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Request;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.RequestConverters;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.asyncsearch.DeleteAsyncSearchRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.asyncsearch.GetAsyncSearchRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.asyncsearch.SubmitAsyncSearchRequest;

final class AsyncSearchRequestConverters {
    AsyncSearchRequestConverters() {
    }

    static Request submitAsyncSearch(SubmitAsyncSearchRequest asyncSearchRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addCommaSeparatedPathParts(asyncSearchRequest.getIndices()).addPathPartAsIs("_async_search").build();
        Request request = new Request("POST", endpoint);
        RequestConverters.Params params = new RequestConverters.Params();
        AsyncSearchRequestConverters.addSearchRequestParams(params, asyncSearchRequest);
        if (asyncSearchRequest.getSearchSource() != null) {
            request.setEntity(RequestConverters.createEntity(asyncSearchRequest.getSearchSource(), RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        }
        if (asyncSearchRequest.isKeepOnCompletion() != null) {
            params.putParam("keep_on_completion", asyncSearchRequest.isKeepOnCompletion().toString());
        }
        if (asyncSearchRequest.getKeepAlive() != null) {
            params.putParam("keep_alive", asyncSearchRequest.getKeepAlive().getStringRep());
        }
        if (asyncSearchRequest.getWaitForCompletionTimeout() != null) {
            params.putParam("wait_for_completion_timeout", asyncSearchRequest.getWaitForCompletionTimeout().getStringRep());
        }
        request.addParameters(params.asMap());
        return request;
    }

    static void addSearchRequestParams(RequestConverters.Params params, SubmitAsyncSearchRequest request) {
        params.putParam("typed_keys", "true");
        params.withRouting(request.getRouting());
        params.withPreference(request.getPreference());
        params.withIndicesOptions(request.getIndicesOptions());
        params.withSearchType(request.getSearchType().name().toLowerCase(Locale.ROOT));
        params.withMaxConcurrentShardRequests(request.getMaxConcurrentShardRequests());
        if (request.getRequestCache() != null) {
            params.withRequestCache(request.getRequestCache());
        }
        if (request.getAllowPartialSearchResults() != null) {
            params.withAllowPartialResults(request.getAllowPartialSearchResults());
        }
        if (request.getBatchedReduceSize() != null) {
            params.withBatchedReduceSize(request.getBatchedReduceSize());
        }
    }

    static Request getAsyncSearch(GetAsyncSearchRequest asyncSearchRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_async_search").addPathPart(asyncSearchRequest.getId()).build();
        Request request = new Request("GET", endpoint);
        RequestConverters.Params params = new RequestConverters.Params();
        if (asyncSearchRequest.getKeepAlive() != null) {
            params.putParam("keep_alive", asyncSearchRequest.getKeepAlive().getStringRep());
        }
        if (asyncSearchRequest.getWaitForCompletion() != null) {
            params.putParam("wait_for_completion_timeout", asyncSearchRequest.getWaitForCompletion().getStringRep());
        }
        request.addParameters(params.asMap());
        return request;
    }

    static Request deleteAsyncSearch(DeleteAsyncSearchRequest deleteAsyncSearchRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_async_search").addPathPart(deleteAsyncSearchRequest.getId()).build();
        return new Request("DELETE", endpoint);
    }
}

