/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client;

import java.util.function.Supplier;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.ContextPreservingActionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Client;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.FilterClient;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.concurrent.ThreadContext;

public final class OriginSettingClient
extends FilterClient {
    private final String origin;

    public OriginSettingClient(Client in, String origin) {
        super(in);
        this.origin = origin;
    }

    @Override
    protected <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        Supplier<ThreadContext.StoredContext> supplier = this.in().threadPool().getThreadContext().newRestorableContext(false);
        try (ThreadContext.StoredContext ignore = this.in().threadPool().getThreadContext().stashWithOrigin(this.origin);){
            super.doExecute(action, request, new ContextPreservingActionListener<Response>(supplier, listener));
        }
    }
}

