/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.job.stats;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.job.stats.SimpleStats;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;

public class ForecastStats
implements ToXContentObject {
    public static final ParseField TOTAL = new ParseField("total", new String[0]);
    public static final ParseField FORECASTED_JOBS = new ParseField("forecasted_jobs", new String[0]);
    public static final ParseField MEMORY_BYTES = new ParseField("memory_bytes", new String[0]);
    public static final ParseField PROCESSING_TIME_MS = new ParseField("processing_time_ms", new String[0]);
    public static final ParseField RECORDS = new ParseField("records", new String[0]);
    public static final ParseField STATUS = new ParseField("status", new String[0]);
    public static final ConstructingObjectParser<ForecastStats, Void> PARSER = new ConstructingObjectParser("forecast_stats", true, a -> {
        int i = 0;
        long total = (Long)a[i++];
        SimpleStats memoryStats = (SimpleStats)a[i++];
        SimpleStats recordStats = (SimpleStats)a[i++];
        SimpleStats runtimeStats = (SimpleStats)a[i++];
        Map statusCounts = (Map)a[i];
        return new ForecastStats(total, memoryStats, recordStats, runtimeStats, statusCounts);
    });
    private final long total;
    private final long forecastedJobs;
    private SimpleStats memoryStats;
    private SimpleStats recordStats;
    private SimpleStats runtimeStats;
    private Map<String, Long> statusCounts;

    public ForecastStats(long total, SimpleStats memoryStats, SimpleStats recordStats, SimpleStats runtimeStats, Map<String, Long> statusCounts) {
        this.total = total;
        long l = this.forecastedJobs = total > 0L ? 1L : 0L;
        if (total > 0L) {
            this.memoryStats = Objects.requireNonNull(memoryStats);
            this.recordStats = Objects.requireNonNull(recordStats);
            this.runtimeStats = Objects.requireNonNull(runtimeStats);
            this.statusCounts = Collections.unmodifiableMap(statusCounts);
        }
    }

    public long getTotal() {
        return this.total;
    }

    public long getForecastedJobs() {
        return this.forecastedJobs;
    }

    public SimpleStats getMemoryStats() {
        return this.memoryStats;
    }

    public SimpleStats getRecordStats() {
        return this.recordStats;
    }

    public SimpleStats getRuntimeStats() {
        return this.runtimeStats;
    }

    public Map<String, Long> getStatusCounts() {
        return this.statusCounts;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TOTAL.getPreferredName(), this.total);
        builder.field(FORECASTED_JOBS.getPreferredName(), this.forecastedJobs);
        if (this.total > 0L) {
            builder.field(MEMORY_BYTES.getPreferredName(), this.memoryStats);
            builder.field(RECORDS.getPreferredName(), this.recordStats);
            builder.field(PROCESSING_TIME_MS.getPreferredName(), this.runtimeStats);
            builder.field(STATUS.getPreferredName(), this.statusCounts);
        }
        return builder.endObject();
    }

    public int hashCode() {
        return Objects.hash(this.total, this.forecastedJobs, this.memoryStats, this.recordStats, this.runtimeStats, this.statusCounts);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ForecastStats other = (ForecastStats)obj;
        return Objects.equals(this.total, other.total) && Objects.equals(this.forecastedJobs, other.forecastedJobs) && Objects.equals(this.memoryStats, other.memoryStats) && Objects.equals(this.recordStats, other.recordStats) && Objects.equals(this.runtimeStats, other.runtimeStats) && Objects.equals(this.statusCounts, other.statusCounts);
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), TOTAL);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), SimpleStats.PARSER, MEMORY_BYTES);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), SimpleStats.PARSER, RECORDS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), SimpleStats.PARSER, PROCESSING_TIME_MS);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> {
            HashMap counts = new HashMap();
            p.map().forEach((key, value) -> counts.put(key, ((Number)value).longValue()));
            return counts;
        }, STATUS, ObjectParser.ValueType.OBJECT);
    }
}

