/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.security;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Validatable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;

public final class InvalidateApiKeyRequest
implements Validatable,
ToXContentObject {
    private final String realmName;
    private final String userName;
    private final String id;
    private final String name;
    private final boolean ownedByAuthenticatedUser;

    InvalidateApiKeyRequest(@Nullable String realmName, @Nullable String userName, @Nullable String apiKeyId, @Nullable String apiKeyName, boolean ownedByAuthenticatedUser) {
        if (!(Strings.hasText(realmName) || Strings.hasText(userName) || Strings.hasText(apiKeyId) || Strings.hasText(apiKeyName) || ownedByAuthenticatedUser)) {
            this.throwValidationError("One of [api key id, api key name, username, realm name] must be specified if [owner] flag is false");
        }
        if ((Strings.hasText(apiKeyId) || Strings.hasText(apiKeyName)) && (Strings.hasText(realmName) || Strings.hasText(userName))) {
            this.throwValidationError("username or realm name must not be specified when the api key id or api key name is specified");
        }
        if (ownedByAuthenticatedUser && (Strings.hasText(realmName) || Strings.hasText(userName))) {
            this.throwValidationError("neither username nor realm-name may be specified when invalidating owned API keys");
        }
        if (Strings.hasText(apiKeyId) && Strings.hasText(apiKeyName)) {
            this.throwValidationError("only one of [api key id, api key name] can be specified");
        }
        this.realmName = realmName;
        this.userName = userName;
        this.id = apiKeyId;
        this.name = apiKeyName;
        this.ownedByAuthenticatedUser = ownedByAuthenticatedUser;
    }

    private void throwValidationError(String message) {
        throw new IllegalArgumentException(message);
    }

    public String getRealmName() {
        return this.realmName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean ownedByAuthenticatedUser() {
        return this.ownedByAuthenticatedUser;
    }

    public static InvalidateApiKeyRequest usingRealmName(String realmName) {
        return new InvalidateApiKeyRequest(realmName, null, null, null, false);
    }

    public static InvalidateApiKeyRequest usingUserName(String userName) {
        return new InvalidateApiKeyRequest(null, userName, null, null, false);
    }

    public static InvalidateApiKeyRequest usingRealmAndUserName(String realmName, String userName) {
        return new InvalidateApiKeyRequest(realmName, userName, null, null, false);
    }

    public static InvalidateApiKeyRequest usingApiKeyId(String apiKeyId, boolean ownedByAuthenticatedUser) {
        return new InvalidateApiKeyRequest(null, null, apiKeyId, null, ownedByAuthenticatedUser);
    }

    public static InvalidateApiKeyRequest usingApiKeyName(String apiKeyName, boolean ownedByAuthenticatedUser) {
        return new InvalidateApiKeyRequest(null, null, null, apiKeyName, ownedByAuthenticatedUser);
    }

    public static InvalidateApiKeyRequest forOwnedApiKeys() {
        return new InvalidateApiKeyRequest(null, null, null, null, true);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.realmName != null) {
            builder.field("realm_name", this.realmName);
        }
        if (this.userName != null) {
            builder.field("username", this.userName);
        }
        if (this.id != null) {
            builder.field("id", this.id);
        }
        if (this.name != null) {
            builder.field("name", this.name);
        }
        builder.field("owner", this.ownedByAuthenticatedUser);
        return builder.endObject();
    }
}

