/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.security.user;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Strings;

public final class User {
    private final String username;
    private final Set<String> roles;
    private final Map<String, Object> metadata;
    @Nullable
    private final String fullName;
    @Nullable
    private final String email;

    public User(String username, Collection<String> roles, Map<String, Object> metadata, @Nullable String fullName, @Nullable String email) {
        this.username = username = Objects.requireNonNull(username, "`username` is required, cannot be null");
        this.roles = Collections.unmodifiableSet(new HashSet<String>(Objects.requireNonNull(roles, "`roles` is required, cannot be null. Pass an empty Collection instead.")));
        this.metadata = Collections.unmodifiableMap(Objects.requireNonNull(metadata, "`metadata` is required, cannot be null. Pass an empty map instead."));
        this.fullName = fullName;
        this.email = email;
    }

    public User(String username, Collection<String> roles) {
        this(username, roles, Collections.emptyMap(), null, null);
    }

    public String getUsername() {
        return this.username;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Nullable
    public String getFullName() {
        return this.fullName;
    }

    @Nullable
    public String getEmail() {
        return this.email;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("User[username=").append(this.username);
        sb.append(",roles=[").append(Strings.collectionToCommaDelimitedString(this.roles)).append("]");
        sb.append(",metadata=").append(this.metadata);
        sb.append(",fullName=").append(this.fullName);
        sb.append(",email=").append(this.email);
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User that = (User)o;
        return Objects.equals(this.username, that.username) && Objects.equals(this.roles, that.roles) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.fullName, that.fullName) && Objects.equals(this.email, that.email);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.roles, this.metadata, this.fullName, this.email);
    }
}

