/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.transform.transforms.pivot;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregatorFactories;

public class AggregationConfig
implements ToXContentObject {
    private final AggregatorFactories.Builder aggregations;

    public static AggregationConfig fromXContent(XContentParser parser) throws IOException {
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        AggregatorFactories.Builder aggregations = AggregatorFactories.parseAggregators(parser);
        return new AggregationConfig(aggregations);
    }

    public AggregationConfig(AggregatorFactories.Builder aggregations) {
        this.aggregations = aggregations;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.aggregations.toXContent(builder, params);
        return builder;
    }

    public Collection<AggregationBuilder> getAggregatorFactories() {
        return this.aggregations.getAggregatorFactories();
    }

    public int hashCode() {
        return Objects.hash(this.aggregations);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AggregationConfig that = (AggregationConfig)other;
        return Objects.equals(this.aggregations, that.aggregations);
    }
}

