/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import java.util.Random;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.store.DataInput;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.store.DataOutput;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.packed.PackedInts;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.Writeable;

public class CuckooFilter
implements Writeable {
    private static final double LN_2 = Math.log(2.0);
    private static final int MAX_EVICTIONS = 500;
    static final int EMPTY = 0;
    private final PackedInts.Mutable data;
    private final int numBuckets;
    private final int bitsPerEntry;
    private final int fingerprintMask;
    private final int entriesPerBucket;
    private final Random rng;
    private int count;
    private int evictedFingerprint = 0;

    CuckooFilter(long capacity, double fpp, Random rng) {
        this.rng = rng;
        this.entriesPerBucket = this.entriesPerBucket(fpp);
        double loadFactor = this.getLoadFactor(this.entriesPerBucket);
        this.bitsPerEntry = this.bitsPerEntry(fpp, this.entriesPerBucket);
        this.numBuckets = this.getNumBuckets(capacity, loadFactor, this.entriesPerBucket);
        if ((long)this.numBuckets * (long)this.entriesPerBucket > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Attempted to create [" + this.numBuckets * this.entriesPerBucket + "] entries which is > Integer.MAX_VALUE");
        }
        this.data = PackedInts.getMutable(this.numBuckets * this.entriesPerBucket, this.bitsPerEntry, 0.0f);
        this.fingerprintMask = Integer.MIN_VALUE >> this.bitsPerEntry - 1 >>> 32 - this.bitsPerEntry;
    }

    CuckooFilter(CuckooFilter other) {
        this.numBuckets = other.numBuckets;
        this.bitsPerEntry = other.bitsPerEntry;
        this.entriesPerBucket = other.entriesPerBucket;
        this.count = other.count;
        this.evictedFingerprint = other.evictedFingerprint;
        this.rng = other.rng;
        this.fingerprintMask = other.fingerprintMask;
        if ((long)this.numBuckets * (long)this.entriesPerBucket > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Attempted to create [" + this.numBuckets * this.entriesPerBucket + "] entries which is > Integer.MAX_VALUE");
        }
        this.data = PackedInts.getMutable(this.numBuckets * this.entriesPerBucket, this.bitsPerEntry, 0.0f);
        for (int i = 0; i < other.data.size(); ++i) {
            this.data.set(i, other.data.get(i));
        }
    }

    CuckooFilter(final StreamInput in, Random rng) throws IOException {
        this.numBuckets = in.readVInt();
        this.bitsPerEntry = in.readVInt();
        this.entriesPerBucket = in.readVInt();
        this.count = in.readVInt();
        this.evictedFingerprint = in.readVInt();
        this.rng = rng;
        this.fingerprintMask = Integer.MIN_VALUE >> this.bitsPerEntry - 1 >>> 32 - this.bitsPerEntry;
        this.data = (PackedInts.Mutable)PackedInts.getReader(new DataInput(){

            @Override
            public byte readByte() throws IOException {
                return in.readByte();
            }

            @Override
            public void readBytes(byte[] b, int offset, int len) throws IOException {
                in.readBytes(b, offset, len);
            }
        });
    }

    @Override
    public void writeTo(final StreamOutput out) throws IOException {
        out.writeVInt(this.numBuckets);
        out.writeVInt(this.bitsPerEntry);
        out.writeVInt(this.entriesPerBucket);
        out.writeVInt(this.count);
        out.writeVInt(this.evictedFingerprint);
        this.data.save(new DataOutput(){

            @Override
            public void writeByte(byte b) throws IOException {
                out.writeByte(b);
            }

            @Override
            public void writeBytes(byte[] b, int offset, int length) throws IOException {
                out.writeBytes(b, offset, length);
            }
        });
    }

    public int getCount() {
        return this.count;
    }

    int getNumBuckets() {
        return this.numBuckets;
    }

    int getBitsPerEntry() {
        return this.bitsPerEntry;
    }

    int getFingerprintMask() {
        return this.fingerprintMask;
    }

    Iterator<long[]> getBuckets() {
        return new Iterator<long[]>(){
            int current = 0;

            @Override
            public boolean hasNext() {
                return this.current < CuckooFilter.this.numBuckets;
            }

            @Override
            public long[] next() {
                long[] values = new long[CuckooFilter.this.entriesPerBucket];
                int offset = CuckooFilter.this.getOffset(this.current, 0);
                CuckooFilter.this.data.get(offset, values, 0, CuckooFilter.this.entriesPerBucket);
                ++this.current;
                return values;
            }
        };
    }

    boolean mightContain(long hash) {
        int bucket = CuckooFilter.hashToIndex((int)hash, this.numBuckets);
        int fingerprint = CuckooFilter.fingerprint((int)(hash >>> 32), this.bitsPerEntry, this.fingerprintMask);
        int alternateIndex = CuckooFilter.alternateIndex(bucket, fingerprint, this.numBuckets);
        return this.mightContainFingerprint(bucket, fingerprint, alternateIndex);
    }

    boolean mightContainFingerprint(int bucket, int fingerprint, int alternateBucket) {
        return this.hasFingerprint(bucket, fingerprint) || this.hasFingerprint(alternateBucket, fingerprint) || this.evictedFingerprint == fingerprint;
    }

    private boolean hasFingerprint(int bucket, long fingerprint) {
        long[] values = new long[this.entriesPerBucket];
        int offset = this.getOffset(bucket, 0);
        this.data.get(offset, values, 0, this.entriesPerBucket);
        for (int i = 0; i < this.entriesPerBucket; ++i) {
            if (values[i] != fingerprint) continue;
            return true;
        }
        return false;
    }

    boolean add(long hash) {
        int bucket = CuckooFilter.hashToIndex((int)hash, this.numBuckets);
        int fingerprint = CuckooFilter.fingerprint((int)(hash >>> 32), this.bitsPerEntry, this.fingerprintMask);
        return this.mergeFingerprint(bucket, fingerprint);
    }

    boolean mergeFingerprint(int bucket, int fingerprint) {
        if (this.evictedFingerprint != 0) {
            return false;
        }
        int alternateBucket = CuckooFilter.alternateIndex(bucket, fingerprint, this.numBuckets);
        if (this.tryInsert(bucket, fingerprint) || this.tryInsert(alternateBucket, fingerprint)) {
            ++this.count;
            return true;
        }
        for (int i = 0; i < 500; ++i) {
            int offset = this.getOffset(alternateBucket, this.rng.nextInt(this.entriesPerBucket - 1));
            int oldFingerprint = (int)this.data.get(offset);
            this.data.set(offset, fingerprint);
            fingerprint = oldFingerprint;
            bucket = alternateBucket;
            alternateBucket = CuckooFilter.alternateIndex(bucket, fingerprint, this.numBuckets);
            if (!this.tryInsert(alternateBucket, fingerprint)) continue;
            ++this.count;
            return true;
        }
        this.evictedFingerprint = fingerprint;
        return false;
    }

    private boolean tryInsert(int bucket, int fingerprint) {
        long[] values = new long[this.entriesPerBucket];
        int offset = this.getOffset(bucket, 0);
        this.data.get(offset, values, 0, this.entriesPerBucket);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == 0L) {
                this.data.set(offset + i, fingerprint);
                return true;
            }
            if (values[i] != (long)fingerprint) continue;
            return true;
        }
        return false;
    }

    static int hashToIndex(int hash, int numBuckets) {
        return hash & numBuckets - 1;
    }

    static int alternateIndex(int bucket, int fingerprint, int numBuckets) {
        int index = bucket ^ fingerprint * 1540483477;
        return CuckooFilter.hashToIndex(index, numBuckets);
    }

    private int getOffset(int bucket, int position) {
        return bucket * this.entriesPerBucket + position;
    }

    static int fingerprint(int hash, int bitsPerEntry, int fingerprintMask) {
        if (hash == 0) {
            return 1;
        }
        int i = 0;
        while (i + bitsPerEntry <= 64) {
            int v = hash >> i & fingerprintMask;
            if (v != 0) {
                return v;
            }
            i += bitsPerEntry;
        }
        return 1;
    }

    private int bitsPerEntry(double fpp, int numEntriesPerBucket) {
        return (int)Math.round(this.log2((double)(2 * numEntriesPerBucket) / fpp));
    }

    private int entriesPerBucket(double fpp) {
        if (fpp > 0.002) {
            return 2;
        }
        if (fpp > 1.0E-5 && fpp <= 0.002) {
            return 4;
        }
        return 8;
    }

    private double getLoadFactor(int b) {
        if (!(b == 2 || b == 4 || b == 8)) {
            throw new IllegalArgumentException("b must be one of [2,4,8]");
        }
        if (b == 2) {
            return 0.84;
        }
        if (b == 4) {
            return 0.955;
        }
        return 0.98;
    }

    private int getNumBuckets(long capacity, double loadFactor, int b) {
        long buckets = Math.round((double)capacity / loadFactor / (double)b);
        return 1 << -Integer.numberOfLeadingZeros((int)buckets - 1);
    }

    private double log2(double x) {
        return Math.log(x) / LN_2;
    }

    public long getSizeInBytes() {
        return this.data.ramBytesUsed() + 24L;
    }

    public int hashCode() {
        return Objects.hash(this.numBuckets, this.bitsPerEntry, this.entriesPerBucket, this.count, this.evictedFingerprint);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CuckooFilter that = (CuckooFilter)other;
        return Objects.equals(this.numBuckets, that.numBuckets) && Objects.equals(this.bitsPerEntry, that.bitsPerEntry) && Objects.equals(this.entriesPerBucket, that.entriesPerBucket) && Objects.equals(this.count, that.count) && Objects.equals(this.evictedFingerprint, that.evictedFingerprint);
    }
}

