/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Priority;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.concurrent.WrappedRunnable;

public abstract class PrioritizedRunnable
implements Runnable,
Comparable<PrioritizedRunnable> {
    private final Priority priority;
    private final long creationDate;
    private final LongSupplier relativeTimeProvider;

    public static WrappedRunnable wrap(Runnable runnable, Priority priority) {
        return new Wrapped(runnable, priority);
    }

    protected PrioritizedRunnable(Priority priority) {
        this(priority, System::nanoTime);
    }

    PrioritizedRunnable(Priority priority, LongSupplier relativeTimeProvider) {
        this.priority = priority;
        this.creationDate = relativeTimeProvider.getAsLong();
        this.relativeTimeProvider = relativeTimeProvider;
    }

    public long getCreationDateInNanos() {
        return this.creationDate;
    }

    public long getAgeInMillis() {
        return TimeUnit.MILLISECONDS.convert(this.relativeTimeProvider.getAsLong() - this.creationDate, TimeUnit.NANOSECONDS);
    }

    @Override
    public int compareTo(PrioritizedRunnable pr) {
        return this.priority.compareTo(pr.priority);
    }

    public Priority priority() {
        return this.priority;
    }

    static class Wrapped
    extends PrioritizedRunnable
    implements WrappedRunnable {
        private final Runnable runnable;

        private Wrapped(Runnable runnable, Priority priority) {
            super(priority);
            this.runnable = runnable;
        }

        @Override
        public void run() {
            this.runnable.run();
        }

        @Override
        public Runnable unwrap() {
            return this.runnable;
        }
    }
}

