/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.index.engine;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.collect.ImmutableOpenMap;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.unit.ByteSizeValue;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;

public class SegmentsStats
implements Writeable,
ToXContentFragment {
    private long count;
    private long memoryInBytes;
    private long termsMemoryInBytes;
    private long storedFieldsMemoryInBytes;
    private long termVectorsMemoryInBytes;
    private long normsMemoryInBytes;
    private long pointsMemoryInBytes;
    private long docValuesMemoryInBytes;
    private long indexWriterMemoryInBytes;
    private long versionMapMemoryInBytes;
    private long maxUnsafeAutoIdTimestamp = Long.MIN_VALUE;
    private long bitsetMemoryInBytes;
    private ImmutableOpenMap<String, Long> fileSizes = ImmutableOpenMap.of();
    private static final ImmutableOpenMap<String, String> FILE_DESCRIPTIONS = ImmutableOpenMap.builder().fPut("si", "Segment Info").fPut("fnm", "Fields").fPut("fdx", "Field Index").fPut("fdt", "Field Data").fPut("tim", "Term Dictionary").fPut("tip", "Term Index").fPut("doc", "Frequencies").fPut("pos", "Positions").fPut("pay", "Payloads").fPut("nvd", "Norms").fPut("nvm", "Norms").fPut("dii", "Points").fPut("dim", "Points").fPut("dvd", "DocValues").fPut("dvm", "DocValues").fPut("tvx", "Term Vector Index").fPut("tvd", "Term Vector Documents").fPut("tvf", "Term Vector Fields").fPut("liv", "Live Documents").build();

    public SegmentsStats() {
    }

    public SegmentsStats(StreamInput in) throws IOException {
        this.count = in.readVLong();
        this.memoryInBytes = in.readLong();
        this.termsMemoryInBytes = in.readLong();
        this.storedFieldsMemoryInBytes = in.readLong();
        this.termVectorsMemoryInBytes = in.readLong();
        this.normsMemoryInBytes = in.readLong();
        this.pointsMemoryInBytes = in.readLong();
        this.docValuesMemoryInBytes = in.readLong();
        this.indexWriterMemoryInBytes = in.readLong();
        this.versionMapMemoryInBytes = in.readLong();
        this.bitsetMemoryInBytes = in.readLong();
        this.maxUnsafeAutoIdTimestamp = in.readLong();
        int size = in.readVInt();
        ImmutableOpenMap.Builder<String, Long> map = ImmutableOpenMap.builder(size);
        for (int i = 0; i < size; ++i) {
            String key = in.readString();
            Long value = in.readLong();
            map.put(key, value);
        }
        this.fileSizes = map.build();
    }

    public void add(long count, long memoryInBytes) {
        this.count += count;
        this.memoryInBytes += memoryInBytes;
    }

    public void addTermsMemoryInBytes(long termsMemoryInBytes) {
        this.termsMemoryInBytes += termsMemoryInBytes;
    }

    public void addStoredFieldsMemoryInBytes(long storedFieldsMemoryInBytes) {
        this.storedFieldsMemoryInBytes += storedFieldsMemoryInBytes;
    }

    public void addTermVectorsMemoryInBytes(long termVectorsMemoryInBytes) {
        this.termVectorsMemoryInBytes += termVectorsMemoryInBytes;
    }

    public void addNormsMemoryInBytes(long normsMemoryInBytes) {
        this.normsMemoryInBytes += normsMemoryInBytes;
    }

    public void addPointsMemoryInBytes(long pointsMemoryInBytes) {
        this.pointsMemoryInBytes += pointsMemoryInBytes;
    }

    public void addDocValuesMemoryInBytes(long docValuesMemoryInBytes) {
        this.docValuesMemoryInBytes += docValuesMemoryInBytes;
    }

    public void addIndexWriterMemoryInBytes(long indexWriterMemoryInBytes) {
        this.indexWriterMemoryInBytes += indexWriterMemoryInBytes;
    }

    public void addVersionMapMemoryInBytes(long versionMapMemoryInBytes) {
        this.versionMapMemoryInBytes += versionMapMemoryInBytes;
    }

    void updateMaxUnsafeAutoIdTimestamp(long maxUnsafeAutoIdTimestamp) {
        this.maxUnsafeAutoIdTimestamp = Math.max(maxUnsafeAutoIdTimestamp, this.maxUnsafeAutoIdTimestamp);
    }

    public void addBitsetMemoryInBytes(long bitsetMemoryInBytes) {
        this.bitsetMemoryInBytes += bitsetMemoryInBytes;
    }

    public void addFileSizes(ImmutableOpenMap<String, Long> fileSizes) {
        ImmutableOpenMap.Builder<String, Long> map = ImmutableOpenMap.builder(this.fileSizes);
        for (ObjectObjectCursor<String, Long> objectObjectCursor : fileSizes) {
            if (map.containsKey((String)objectObjectCursor.key)) {
                Long oldValue = map.get((String)objectObjectCursor.key);
                map.put((String)objectObjectCursor.key, oldValue + (Long)objectObjectCursor.value);
                continue;
            }
            map.put((String)objectObjectCursor.key, (Long)objectObjectCursor.value);
        }
        this.fileSizes = map.build();
    }

    public void add(SegmentsStats mergeStats) {
        if (mergeStats == null) {
            return;
        }
        this.updateMaxUnsafeAutoIdTimestamp(mergeStats.maxUnsafeAutoIdTimestamp);
        this.add(mergeStats.count, mergeStats.memoryInBytes);
        this.addTermsMemoryInBytes(mergeStats.termsMemoryInBytes);
        this.addStoredFieldsMemoryInBytes(mergeStats.storedFieldsMemoryInBytes);
        this.addTermVectorsMemoryInBytes(mergeStats.termVectorsMemoryInBytes);
        this.addNormsMemoryInBytes(mergeStats.normsMemoryInBytes);
        this.addPointsMemoryInBytes(mergeStats.pointsMemoryInBytes);
        this.addDocValuesMemoryInBytes(mergeStats.docValuesMemoryInBytes);
        this.addIndexWriterMemoryInBytes(mergeStats.indexWriterMemoryInBytes);
        this.addVersionMapMemoryInBytes(mergeStats.versionMapMemoryInBytes);
        this.addBitsetMemoryInBytes(mergeStats.bitsetMemoryInBytes);
        this.addFileSizes(mergeStats.fileSizes);
    }

    public long getCount() {
        return this.count;
    }

    public long getMemoryInBytes() {
        return this.memoryInBytes;
    }

    public ByteSizeValue getMemory() {
        return new ByteSizeValue(this.memoryInBytes);
    }

    public long getTermsMemoryInBytes() {
        return this.termsMemoryInBytes;
    }

    private ByteSizeValue getTermsMemory() {
        return new ByteSizeValue(this.termsMemoryInBytes);
    }

    public long getStoredFieldsMemoryInBytes() {
        return this.storedFieldsMemoryInBytes;
    }

    private ByteSizeValue getStoredFieldsMemory() {
        return new ByteSizeValue(this.storedFieldsMemoryInBytes);
    }

    public long getTermVectorsMemoryInBytes() {
        return this.termVectorsMemoryInBytes;
    }

    private ByteSizeValue getTermVectorsMemory() {
        return new ByteSizeValue(this.termVectorsMemoryInBytes);
    }

    public long getNormsMemoryInBytes() {
        return this.normsMemoryInBytes;
    }

    private ByteSizeValue getNormsMemory() {
        return new ByteSizeValue(this.normsMemoryInBytes);
    }

    public long getPointsMemoryInBytes() {
        return this.pointsMemoryInBytes;
    }

    private ByteSizeValue getPointsMemory() {
        return new ByteSizeValue(this.pointsMemoryInBytes);
    }

    public long getDocValuesMemoryInBytes() {
        return this.docValuesMemoryInBytes;
    }

    private ByteSizeValue getDocValuesMemory() {
        return new ByteSizeValue(this.docValuesMemoryInBytes);
    }

    public long getIndexWriterMemoryInBytes() {
        return this.indexWriterMemoryInBytes;
    }

    public ByteSizeValue getIndexWriterMemory() {
        return new ByteSizeValue(this.indexWriterMemoryInBytes);
    }

    public long getVersionMapMemoryInBytes() {
        return this.versionMapMemoryInBytes;
    }

    public ByteSizeValue getVersionMapMemory() {
        return new ByteSizeValue(this.versionMapMemoryInBytes);
    }

    public long getBitsetMemoryInBytes() {
        return this.bitsetMemoryInBytes;
    }

    public ByteSizeValue getBitsetMemory() {
        return new ByteSizeValue(this.bitsetMemoryInBytes);
    }

    public ImmutableOpenMap<String, Long> getFileSizes() {
        return this.fileSizes;
    }

    public long getMaxUnsafeAutoIdTimestamp() {
        return this.maxUnsafeAutoIdTimestamp;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("segments");
        builder.field("count", this.count);
        builder.humanReadableField("memory_in_bytes", "memory", this.getMemory());
        builder.humanReadableField("terms_memory_in_bytes", "terms_memory", this.getTermsMemory());
        builder.humanReadableField("stored_fields_memory_in_bytes", "stored_fields_memory", this.getStoredFieldsMemory());
        builder.humanReadableField("term_vectors_memory_in_bytes", "term_vectors_memory", this.getTermVectorsMemory());
        builder.humanReadableField("norms_memory_in_bytes", "norms_memory", this.getNormsMemory());
        builder.humanReadableField("points_memory_in_bytes", "points_memory", this.getPointsMemory());
        builder.humanReadableField("doc_values_memory_in_bytes", "doc_values_memory", this.getDocValuesMemory());
        builder.humanReadableField("index_writer_memory_in_bytes", "index_writer_memory", this.getIndexWriterMemory());
        builder.humanReadableField("version_map_memory_in_bytes", "version_map_memory", this.getVersionMapMemory());
        builder.humanReadableField("fixed_bit_set_memory_in_bytes", "fixed_bit_set", this.getBitsetMemory());
        builder.field("max_unsafe_auto_id_timestamp", this.maxUnsafeAutoIdTimestamp);
        builder.startObject("file_sizes");
        for (ObjectObjectCursor<String, Long> objectObjectCursor : this.fileSizes) {
            builder.startObject((String)objectObjectCursor.key);
            builder.humanReadableField("size_in_bytes", "size", new ByteSizeValue((Long)objectObjectCursor.value));
            builder.field("description", FILE_DESCRIPTIONS.getOrDefault((String)objectObjectCursor.key, "Others"));
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.count);
        out.writeLong(this.memoryInBytes);
        out.writeLong(this.termsMemoryInBytes);
        out.writeLong(this.storedFieldsMemoryInBytes);
        out.writeLong(this.termVectorsMemoryInBytes);
        out.writeLong(this.normsMemoryInBytes);
        out.writeLong(this.pointsMemoryInBytes);
        out.writeLong(this.docValuesMemoryInBytes);
        out.writeLong(this.indexWriterMemoryInBytes);
        out.writeLong(this.versionMapMemoryInBytes);
        out.writeLong(this.bitsetMemoryInBytes);
        out.writeLong(this.maxUnsafeAutoIdTimestamp);
        out.writeVInt(this.fileSizes.size());
        for (ObjectObjectCursor<String, Long> objectObjectCursor : this.fileSizes) {
            out.writeString((String)objectObjectCursor.key);
            out.writeLong((Long)objectObjectCursor.value);
        }
    }

    public void clearFileSizes() {
        this.fileSizes = ImmutableOpenMap.of();
    }

    static final class Fields {
        static final String SEGMENTS = "segments";
        static final String COUNT = "count";
        static final String MEMORY = "memory";
        static final String MEMORY_IN_BYTES = "memory_in_bytes";
        static final String TERMS_MEMORY = "terms_memory";
        static final String TERMS_MEMORY_IN_BYTES = "terms_memory_in_bytes";
        static final String STORED_FIELDS_MEMORY = "stored_fields_memory";
        static final String STORED_FIELDS_MEMORY_IN_BYTES = "stored_fields_memory_in_bytes";
        static final String TERM_VECTORS_MEMORY = "term_vectors_memory";
        static final String TERM_VECTORS_MEMORY_IN_BYTES = "term_vectors_memory_in_bytes";
        static final String NORMS_MEMORY = "norms_memory";
        static final String NORMS_MEMORY_IN_BYTES = "norms_memory_in_bytes";
        static final String POINTS_MEMORY = "points_memory";
        static final String POINTS_MEMORY_IN_BYTES = "points_memory_in_bytes";
        static final String DOC_VALUES_MEMORY = "doc_values_memory";
        static final String DOC_VALUES_MEMORY_IN_BYTES = "doc_values_memory_in_bytes";
        static final String INDEX_WRITER_MEMORY = "index_writer_memory";
        static final String INDEX_WRITER_MEMORY_IN_BYTES = "index_writer_memory_in_bytes";
        static final String VERSION_MAP_MEMORY = "version_map_memory";
        static final String VERSION_MAP_MEMORY_IN_BYTES = "version_map_memory_in_bytes";
        static final String MAX_UNSAFE_AUTO_ID_TIMESTAMP = "max_unsafe_auto_id_timestamp";
        static final String FIXED_BIT_SET = "fixed_bit_set";
        static final String FIXED_BIT_SET_MEMORY_IN_BYTES = "fixed_bit_set_memory_in_bytes";
        static final String FILE_SIZES = "file_sizes";
        static final String SIZE = "size";
        static final String SIZE_IN_BYTES = "size_in_bytes";
        static final String DESCRIPTION = "description";

        Fields() {
        }
    }
}

