/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.graylog.shaded.elasticsearch7.com.fasterxml.jackson.core.JsonParseException;
import org.graylog.shaded.elasticsearch7.com.fasterxml.jackson.core.exc.InputCoercionException;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.DoublePoint;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.Field;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.FieldType;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.FloatPoint;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.HalfFloatPoint;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.IntPoint;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.LongPoint;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.SortedNumericDocValuesField;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.StoredField;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.Term;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.BoostQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.IndexOrDocValuesQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.MatchNoDocsQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.TermQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.NumericUtils;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Explicit;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Numbers;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lucene.Lucene;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lucene.search.Queries;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.Setting;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.FieldMapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.Mapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MapperParsingException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.ParseContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.TextSearchInfo;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.TypeParsers;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryShardContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.DocValueFormat;

public class NumberFieldMapper
extends FieldMapper {
    public static final Setting<Boolean> COERCE_SETTING = Setting.boolSetting("index.mapping.coerce", true, Setting.Property.IndexScope);
    private Explicit<Boolean> ignoreMalformed;
    private Explicit<Boolean> coerce;
    private final Number nullValue;

    private NumberFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Number nullValue, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, mappedFieldType, multiFields, copyTo);
        this.ignoreMalformed = ignoreMalformed;
        this.coerce = coerce;
        this.nullValue = nullValue;
    }

    @Override
    public NumberFieldType fieldType() {
        return (NumberFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType().type.typeName();
    }

    @Override
    protected NumberFieldMapper clone() {
        return (NumberFieldMapper)super.clone();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        Object value;
        XContentParser parser = context.parser();
        Number numericValue = null;
        if (context.externalValueSet()) {
            value = context.externalValue();
        } else if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            value = null;
        } else if (this.coerce.value().booleanValue() && parser.currentToken() == XContentParser.Token.VALUE_STRING && parser.textLength() == 0) {
            value = null;
        } else {
            try {
                numericValue = this.fieldType().type.parse(parser, (boolean)this.coerce.value());
            }
            catch (IllegalArgumentException | JsonParseException | InputCoercionException e) {
                if (this.ignoreMalformed.value().booleanValue() && parser.currentToken().isValue()) {
                    context.addIgnoredField(this.mappedFieldType.name());
                    return;
                }
                throw e;
            }
            value = numericValue;
        }
        if (value == null) {
            value = this.nullValue;
        }
        if (value == null) {
            return;
        }
        if (numericValue == null) {
            numericValue = this.fieldType().type.parse(value, (boolean)this.coerce.value());
        }
        boolean docValued = this.fieldType().hasDocValues();
        boolean stored = this.fieldType.stored();
        context.doc().addAll(this.fieldType().type.createFields(this.fieldType().name(), numericValue, this.fieldType().isSearchable(), docValued, stored));
        if (!docValued && (stored || this.fieldType().isSearchable())) {
            this.createFieldNamesField(context);
        }
    }

    @Override
    protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        NumberFieldMapper m = (NumberFieldMapper)other;
        if (this.fieldType().type != m.fieldType().type) {
            conflicts.add("mapper [" + this.name() + "] cannot be changed from type [" + this.fieldType().type.name + "] to [" + m.fieldType().type.name + "]");
        } else {
            if (m.ignoreMalformed.explicit()) {
                this.ignoreMalformed = m.ignoreMalformed;
            }
            if (m.coerce.explicit()) {
                this.coerce = m.coerce;
            }
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field("ignore_malformed", this.ignoreMalformed.value());
        }
        if (includeDefaults || this.coerce.explicit()) {
            builder.field("coerce", this.coerce.value());
        }
        if (this.nullValue != null) {
            builder.field("null_value", this.nullValue);
        }
    }

    public static final class NumberFieldType
    extends SimpleMappedFieldType {
        private final NumberType type;

        public NumberFieldType(String name, NumberType type, boolean isSearchable, boolean hasDocValues, Map<String, String> meta) {
            super(name, isSearchable, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.type = Objects.requireNonNull(type);
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
        }

        public NumberFieldType(String name, NumberType type) {
            this(name, type, true, true, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return this.type.name;
        }

        public IndexNumericFieldData.NumericType numericType() {
            return this.type.numericType();
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            if (this.hasDocValues()) {
                return new DocValuesFieldExistsQuery(this.name());
            }
            return new TermQuery(new Term("_field_names", this.name()));
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            this.failIfNotIndexed();
            Query query = this.type.termQuery(this.name(), value);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        public Query termsQuery(List values, QueryShardContext context) {
            this.failIfNotIndexed();
            Query query = this.type.termsQuery(this.name(), values);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            this.failIfNotIndexed();
            Query query = this.type.rangeQuery(this.name(), lowerTerm, upperTerm, includeLower, includeUpper, this.hasDocValues());
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public Function<byte[], Number> pointReaderIfPossible() {
            if (this.isSearchable()) {
                return this::parsePoint;
            }
            return null;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            this.failIfNoDocValues();
            return new SortedNumericIndexFieldData.Builder(this.type.numericType());
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            return this.type.valueForSearch((Number)value);
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            if (timeZone != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
            }
            if (format == null) {
                return DocValueFormat.RAW;
            }
            return new DocValueFormat.Decimal(format);
        }

        public Number parsePoint(byte[] value) {
            return this.type.parsePoint(value);
        }
    }

    public static enum NumberType {
        HALF_FLOAT("half_float", IndexNumericFieldData.NumericType.HALF_FLOAT){

            @Override
            public Float parse(Object value, boolean coerce) {
                float result;
                if (value instanceof Number) {
                    result = ((Number)value).floatValue();
                } else {
                    if (value instanceof BytesRef) {
                        value = ((BytesRef)value).utf8ToString();
                    }
                    result = Float.parseFloat(value.toString());
                }
                this.validateParsed(result);
                return Float.valueOf(result);
            }

            @Override
            public Number parsePoint(byte[] value) {
                return Float.valueOf(HalfFloatPoint.decodeDimension(value, 0));
            }

            @Override
            public Float parse(XContentParser parser, boolean coerce) throws IOException {
                float parsed = parser.floatValue(coerce);
                this.validateParsed(parsed);
                return Float.valueOf(parsed);
            }

            @Override
            public Query termQuery(String field, Object value) {
                float v = this.parse(value, false).floatValue();
                return HalfFloatPoint.newExactQuery(field, v);
            }

            @Override
            public Query termsQuery(String field, List<Object> values) {
                float[] v = new float[values.size()];
                for (int i = 0; i < values.size(); ++i) {
                    v[i] = this.parse(values.get(i), false).floatValue();
                }
                return HalfFloatPoint.newSetQuery(field, v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues) {
                float l = Float.NEGATIVE_INFINITY;
                float u = Float.POSITIVE_INFINITY;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm, false).floatValue();
                    if (includeLower) {
                        l = HalfFloatPoint.nextDown(l);
                    }
                    l = HalfFloatPoint.nextUp(l);
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm, false).floatValue();
                    if (includeUpper) {
                        u = HalfFloatPoint.nextUp(u);
                    }
                    u = HalfFloatPoint.nextDown(u);
                }
                Query query = HalfFloatPoint.newRangeQuery(field, l, u);
                if (hasDocValues) {
                    Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery(field, HalfFloatPoint.halfFloatToSortableShort(l), HalfFloatPoint.halfFloatToSortableShort(u));
                    query = new IndexOrDocValuesQuery(query, dvQuery);
                }
                return query;
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add(new HalfFloatPoint(name, value.floatValue()));
                }
                if (docValued) {
                    fields.add(new SortedNumericDocValuesField(name, HalfFloatPoint.halfFloatToSortableShort(value.floatValue())));
                }
                if (stored) {
                    fields.add(new StoredField(name, value.floatValue()));
                }
                return fields;
            }

            private void validateParsed(float value) {
                if (!Float.isFinite(HalfFloatPoint.sortableShortToHalfFloat(HalfFloatPoint.halfFloatToSortableShort(value)))) {
                    throw new IllegalArgumentException("[half_float] supports only finite values, but got [" + value + "]");
                }
            }
        }
        ,
        FLOAT("float", IndexNumericFieldData.NumericType.FLOAT){

            @Override
            public Float parse(Object value, boolean coerce) {
                float result;
                if (value instanceof Number) {
                    result = ((Number)value).floatValue();
                } else {
                    if (value instanceof BytesRef) {
                        value = ((BytesRef)value).utf8ToString();
                    }
                    result = Float.parseFloat(value.toString());
                }
                this.validateParsed(result);
                return Float.valueOf(result);
            }

            @Override
            public Number parsePoint(byte[] value) {
                return Float.valueOf(FloatPoint.decodeDimension(value, 0));
            }

            @Override
            public Float parse(XContentParser parser, boolean coerce) throws IOException {
                float parsed = parser.floatValue(coerce);
                this.validateParsed(parsed);
                return Float.valueOf(parsed);
            }

            @Override
            public Query termQuery(String field, Object value) {
                float v = this.parse(value, false).floatValue();
                return FloatPoint.newExactQuery(field, v);
            }

            @Override
            public Query termsQuery(String field, List<Object> values) {
                float[] v = new float[values.size()];
                for (int i = 0; i < values.size(); ++i) {
                    v[i] = this.parse(values.get(i), false).floatValue();
                }
                return FloatPoint.newSetQuery(field, v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues) {
                float l = Float.NEGATIVE_INFINITY;
                float u = Float.POSITIVE_INFINITY;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm, false).floatValue();
                    if (!includeLower) {
                        l = FloatPoint.nextUp(l);
                    }
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm, false).floatValue();
                    if (!includeUpper) {
                        u = FloatPoint.nextDown(u);
                    }
                }
                Query query = FloatPoint.newRangeQuery(field, l, u);
                if (hasDocValues) {
                    Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery(field, NumericUtils.floatToSortableInt(l), NumericUtils.floatToSortableInt(u));
                    query = new IndexOrDocValuesQuery(query, dvQuery);
                }
                return query;
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add(new FloatPoint(name, value.floatValue()));
                }
                if (docValued) {
                    fields.add(new SortedNumericDocValuesField(name, NumericUtils.floatToSortableInt(value.floatValue())));
                }
                if (stored) {
                    fields.add(new StoredField(name, value.floatValue()));
                }
                return fields;
            }

            private void validateParsed(float value) {
                if (!Float.isFinite(value)) {
                    throw new IllegalArgumentException("[float] supports only finite values, but got [" + value + "]");
                }
            }
        }
        ,
        DOUBLE("double", IndexNumericFieldData.NumericType.DOUBLE){

            @Override
            public Double parse(Object value, boolean coerce) {
                double parsed = NumberType.objectToDouble(value);
                this.validateParsed(parsed);
                return parsed;
            }

            @Override
            public Number parsePoint(byte[] value) {
                return DoublePoint.decodeDimension(value, 0);
            }

            @Override
            public Double parse(XContentParser parser, boolean coerce) throws IOException {
                double parsed = parser.doubleValue(coerce);
                this.validateParsed(parsed);
                return parsed;
            }

            @Override
            public Query termQuery(String field, Object value) {
                double v = this.parse(value, false);
                return DoublePoint.newExactQuery(field, v);
            }

            @Override
            public Query termsQuery(String field, List<Object> values) {
                double[] v = new double[values.size()];
                for (int i = 0; i < values.size(); ++i) {
                    v[i] = this.parse(values.get(i), false);
                }
                return DoublePoint.newSetQuery(field, v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues) {
                double l = Double.NEGATIVE_INFINITY;
                double u = Double.POSITIVE_INFINITY;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm, false);
                    if (!includeLower) {
                        l = DoublePoint.nextUp(l);
                    }
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm, false);
                    if (!includeUpper) {
                        u = DoublePoint.nextDown(u);
                    }
                }
                Query query = DoublePoint.newRangeQuery(field, l, u);
                if (hasDocValues) {
                    Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery(field, NumericUtils.doubleToSortableLong(l), NumericUtils.doubleToSortableLong(u));
                    query = new IndexOrDocValuesQuery(query, dvQuery);
                }
                return query;
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add(new DoublePoint(name, value.doubleValue()));
                }
                if (docValued) {
                    fields.add(new SortedNumericDocValuesField(name, NumericUtils.doubleToSortableLong(value.doubleValue())));
                }
                if (stored) {
                    fields.add(new StoredField(name, value.doubleValue()));
                }
                return fields;
            }

            private void validateParsed(double value) {
                if (!Double.isFinite(value)) {
                    throw new IllegalArgumentException("[double] supports only finite values, but got [" + value + "]");
                }
            }
        }
        ,
        BYTE("byte", IndexNumericFieldData.NumericType.BYTE){

            @Override
            public Byte parse(Object value, boolean coerce) {
                double doubleValue = NumberType.objectToDouble(value);
                if (doubleValue < -128.0 || doubleValue > 127.0) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for a byte");
                }
                if (!coerce && doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
                }
                if (value instanceof Number) {
                    return ((Number)value).byteValue();
                }
                return (byte)doubleValue;
            }

            @Override
            public Number parsePoint(byte[] value) {
                return INTEGER.parsePoint(value).byteValue();
            }

            @Override
            public Short parse(XContentParser parser, boolean coerce) throws IOException {
                int value = parser.intValue(coerce);
                if (value < -128 || value > 127) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for a byte");
                }
                return (short)value;
            }

            @Override
            public Query termQuery(String field, Object value) {
                return INTEGER.termQuery(field, value);
            }

            @Override
            public Query termsQuery(String field, List<Object> values) {
                return INTEGER.termsQuery(field, values);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues) {
                return INTEGER.rangeQuery(field, lowerTerm, upperTerm, includeLower, includeUpper, hasDocValues);
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                return INTEGER.createFields(name, value, indexed, docValued, stored);
            }

            @Override
            Number valueForSearch(Number value) {
                return value.byteValue();
            }
        }
        ,
        SHORT("short", IndexNumericFieldData.NumericType.SHORT){

            @Override
            public Short parse(Object value, boolean coerce) {
                double doubleValue = NumberType.objectToDouble(value);
                if (doubleValue < -32768.0 || doubleValue > 32767.0) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for a short");
                }
                if (!coerce && doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
                }
                if (value instanceof Number) {
                    return ((Number)value).shortValue();
                }
                return (short)doubleValue;
            }

            @Override
            public Number parsePoint(byte[] value) {
                return INTEGER.parsePoint(value).shortValue();
            }

            @Override
            public Short parse(XContentParser parser, boolean coerce) throws IOException {
                return parser.shortValue(coerce);
            }

            @Override
            public Query termQuery(String field, Object value) {
                return INTEGER.termQuery(field, value);
            }

            @Override
            public Query termsQuery(String field, List<Object> values) {
                return INTEGER.termsQuery(field, values);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues) {
                return INTEGER.rangeQuery(field, lowerTerm, upperTerm, includeLower, includeUpper, hasDocValues);
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                return INTEGER.createFields(name, value, indexed, docValued, stored);
            }

            @Override
            Number valueForSearch(Number value) {
                return value.shortValue();
            }
        }
        ,
        INTEGER("integer", IndexNumericFieldData.NumericType.INT){

            @Override
            public Integer parse(Object value, boolean coerce) {
                double doubleValue = NumberType.objectToDouble(value);
                if (doubleValue < -2.147483648E9 || doubleValue > 2.147483647E9) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for an integer");
                }
                if (!coerce && doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
                }
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                return (int)doubleValue;
            }

            @Override
            public Number parsePoint(byte[] value) {
                return IntPoint.decodeDimension(value, 0);
            }

            @Override
            public Integer parse(XContentParser parser, boolean coerce) throws IOException {
                return parser.intValue(coerce);
            }

            @Override
            public Query termQuery(String field, Object value) {
                if (this.hasDecimalPart(value)) {
                    return Queries.newMatchNoDocsQuery("Value [" + value + "] has a decimal part");
                }
                int v = this.parse(value, true);
                return IntPoint.newExactQuery(field, v);
            }

            @Override
            public Query termsQuery(String field, List<Object> values) {
                int[] v = new int[values.size()];
                int upTo = 0;
                for (int i = 0; i < values.size(); ++i) {
                    Object value = values.get(i);
                    if (this.hasDecimalPart(value)) continue;
                    v[upTo++] = this.parse(value, true);
                }
                if (upTo == 0) {
                    return Queries.newMatchNoDocsQuery("All values have a decimal part");
                }
                if (upTo != v.length) {
                    v = Arrays.copyOf(v, upTo);
                }
                return IntPoint.newSetQuery(field, v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues) {
                int l = Integer.MIN_VALUE;
                int u = Integer.MAX_VALUE;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm, true);
                    boolean lowerTermHasDecimalPart = this.hasDecimalPart(lowerTerm);
                    if (!lowerTermHasDecimalPart && !includeLower || lowerTermHasDecimalPart && this.signum(lowerTerm) > 0.0) {
                        if (l == Integer.MAX_VALUE) {
                            return new MatchNoDocsQuery();
                        }
                        ++l;
                    }
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm, true);
                    boolean upperTermHasDecimalPart = this.hasDecimalPart(upperTerm);
                    if (!upperTermHasDecimalPart && !includeUpper || upperTermHasDecimalPart && this.signum(upperTerm) < 0.0) {
                        if (u == Integer.MIN_VALUE) {
                            return new MatchNoDocsQuery();
                        }
                        --u;
                    }
                }
                Query query = IntPoint.newRangeQuery(field, l, u);
                if (hasDocValues) {
                    Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery(field, l, u);
                    query = new IndexOrDocValuesQuery(query, dvQuery);
                }
                return query;
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add(new IntPoint(name, value.intValue()));
                }
                if (docValued) {
                    fields.add(new SortedNumericDocValuesField(name, value.intValue()));
                }
                if (stored) {
                    fields.add(new StoredField(name, value.intValue()));
                }
                return fields;
            }
        }
        ,
        LONG("long", IndexNumericFieldData.NumericType.LONG){

            @Override
            public Long parse(Object value, boolean coerce) {
                if (value instanceof Long) {
                    return (Long)value;
                }
                double doubleValue = NumberType.objectToDouble(value);
                if (doubleValue < -9.223372036854776E18 || doubleValue > 9.223372036854776E18) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for a long");
                }
                if (!coerce && doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
                }
                String stringValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
                return Numbers.toLong(stringValue, coerce);
            }

            @Override
            public Number parsePoint(byte[] value) {
                return LongPoint.decodeDimension(value, 0);
            }

            @Override
            public Long parse(XContentParser parser, boolean coerce) throws IOException {
                return parser.longValue(coerce);
            }

            @Override
            public Query termQuery(String field, Object value) {
                if (this.hasDecimalPart(value)) {
                    return Queries.newMatchNoDocsQuery("Value [" + value + "] has a decimal part");
                }
                long v = this.parse(value, true);
                return LongPoint.newExactQuery(field, v);
            }

            @Override
            public Query termsQuery(String field, List<Object> values) {
                long[] v = new long[values.size()];
                int upTo = 0;
                for (int i = 0; i < values.size(); ++i) {
                    Object value = values.get(i);
                    if (this.hasDecimalPart(value)) continue;
                    v[upTo++] = this.parse(value, true);
                }
                if (upTo == 0) {
                    return Queries.newMatchNoDocsQuery("All values have a decimal part");
                }
                if (upTo != v.length) {
                    v = Arrays.copyOf(v, upTo);
                }
                return LongPoint.newSetQuery(field, v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues) {
                long l = Long.MIN_VALUE;
                long u = Long.MAX_VALUE;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm, true);
                    boolean lowerTermHasDecimalPart = this.hasDecimalPart(lowerTerm);
                    if (!lowerTermHasDecimalPart && !includeLower || lowerTermHasDecimalPart && this.signum(lowerTerm) > 0.0) {
                        if (l == Long.MAX_VALUE) {
                            return new MatchNoDocsQuery();
                        }
                        ++l;
                    }
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm, true);
                    boolean upperTermHasDecimalPart = this.hasDecimalPart(upperTerm);
                    if (!upperTermHasDecimalPart && !includeUpper || upperTermHasDecimalPart && this.signum(upperTerm) < 0.0) {
                        if (u == Long.MIN_VALUE) {
                            return new MatchNoDocsQuery();
                        }
                        --u;
                    }
                }
                Query query = LongPoint.newRangeQuery(field, l, u);
                if (hasDocValues) {
                    Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery(field, l, u);
                    query = new IndexOrDocValuesQuery(query, dvQuery);
                }
                return query;
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add(new LongPoint(name, value.longValue()));
                }
                if (docValued) {
                    fields.add(new SortedNumericDocValuesField(name, value.longValue()));
                }
                if (stored) {
                    fields.add(new StoredField(name, value.longValue()));
                }
                return fields;
            }
        };

        private final String name;
        private final IndexNumericFieldData.NumericType numericType;

        private NumberType(String name, IndexNumericFieldData.NumericType numericType) {
            this.name = name;
            this.numericType = numericType;
        }

        public final String typeName() {
            return this.name;
        }

        public final IndexNumericFieldData.NumericType numericType() {
            return this.numericType;
        }

        public abstract Query termQuery(String var1, Object var2);

        public abstract Query termsQuery(String var1, List<Object> var2);

        public abstract Query rangeQuery(String var1, Object var2, Object var3, boolean var4, boolean var5, boolean var6);

        public abstract Number parse(XContentParser var1, boolean var2) throws IOException;

        public abstract Number parse(Object var1, boolean var2);

        public abstract Number parsePoint(byte[] var1);

        public abstract List<Field> createFields(String var1, Number var2, boolean var3, boolean var4, boolean var5);

        Number valueForSearch(Number value) {
            return value;
        }

        boolean hasDecimalPart(Object number) {
            if (number instanceof Number) {
                double doubleValue = ((Number)number).doubleValue();
                return doubleValue % 1.0 != 0.0;
            }
            if (number instanceof BytesRef) {
                number = ((BytesRef)number).utf8ToString();
            }
            if (number instanceof String) {
                return Double.parseDouble((String)number) % 1.0 != 0.0;
            }
            return false;
        }

        double signum(Object value) {
            if (value instanceof Number) {
                double doubleValue = ((Number)value).doubleValue();
                return Math.signum(doubleValue);
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return Math.signum(Double.parseDouble(value.toString()));
        }

        private static double objectToDouble(Object value) {
            double doubleValue = value instanceof Number ? ((Number)value).doubleValue() : (value instanceof BytesRef ? Double.parseDouble(((BytesRef)value).utf8ToString()) : Double.parseDouble(value.toString()));
            return doubleValue;
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        final NumberType type;

        public TypeParser(NumberType type) {
            this.type = type;
        }

        @Override
        public Mapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name, this.type);
            TypeParsers.parseField(builder, name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (propName.equals("null_value")) {
                    if (propNode == null) {
                        throw new MapperParsingException("Property [null_value] cannot be null.");
                    }
                    builder.nullValue(this.type.parse(propNode, false));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("ignore_malformed")) {
                    builder.ignoreMalformed(XContentMapValues.nodeBooleanValue(propNode, name + ".ignore_malformed"));
                    iterator.remove();
                    continue;
                }
                if (!propName.equals("coerce")) continue;
                builder.coerce(XContentMapValues.nodeBooleanValue(propNode, name + ".coerce"));
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder> {
        private Boolean ignoreMalformed;
        private Boolean coerce;
        private Number nullValue;
        private final NumberType type;

        public Builder(String name, NumberType type) {
            super(name, Defaults.FIELD_TYPE);
            this.type = type;
            this.builder = this;
        }

        public Builder ignoreMalformed(boolean ignoreMalformed) {
            this.ignoreMalformed = ignoreMalformed;
            return (Builder)this.builder;
        }

        public Builder nullValue(Number nullValue) {
            this.nullValue = nullValue;
            return (Builder)this.builder;
        }

        @Override
        public Builder indexOptions(IndexOptions indexOptions) {
            throw new MapperParsingException("index_options not allowed in field [" + this.name + "] of type [" + this.type.typeName() + "]");
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit<Boolean>(this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(FieldMapper.IGNORE_MALFORMED_SETTING.get(context.indexSettings()), false);
            }
            return Defaults.IGNORE_MALFORMED;
        }

        public Builder coerce(boolean coerce) {
            this.coerce = coerce;
            return (Builder)this.builder;
        }

        protected Explicit<Boolean> coerce(Mapper.BuilderContext context) {
            if (this.coerce != null) {
                return new Explicit<Boolean>(this.coerce, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(COERCE_SETTING.get(context.indexSettings()), false);
            }
            return Defaults.COERCE;
        }

        @Override
        public NumberFieldMapper build(Mapper.BuilderContext context) {
            return new NumberFieldMapper(this.name, this.fieldType, new NumberFieldType(this.buildFullName(context), this.type, this.indexed, this.hasDocValues, (Map<String, String>)this.meta), this.ignoreMalformed(context), this.coerce(context), this.nullValue, this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final Explicit<Boolean> IGNORE_MALFORMED = new Explicit<Boolean>(false, false);
        public static final Explicit<Boolean> COERCE = new Explicit<Boolean>(true, false);
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.freeze();
        }
    }
}

