/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.ReaderUtil;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.SearchHit;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.fetch.FetchSubPhase;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.internal.SearchContext;

public final class SeqNoPrimaryTermPhase
implements FetchSubPhase {
    @Override
    public void hitsExecute(SearchContext context, SearchHit[] hits) throws IOException {
        if (!context.seqNoAndPrimaryTerm()) {
            return;
        }
        int lastReaderId = -1;
        NumericDocValues seqNoField = null;
        NumericDocValues primaryTermField = null;
        for (SearchHit hit : hits) {
            int readerId = ReaderUtil.subIndex(hit.docId(), context.searcher().getIndexReader().leaves());
            LeafReaderContext subReaderContext = context.searcher().getIndexReader().leaves().get(readerId);
            if (lastReaderId != readerId) {
                seqNoField = subReaderContext.reader().getNumericDocValues("_seq_no");
                primaryTermField = subReaderContext.reader().getNumericDocValues("_primary_term");
                lastReaderId = readerId;
            }
            int docId = hit.docId() - subReaderContext.docBase;
            long seqNo = -2L;
            long primaryTerm = 0L;
            if (primaryTermField != null && primaryTermField.advanceExact(docId)) {
                boolean found = seqNoField.advanceExact(docId);
                assert (found) : "found seq no for " + docId + " but not a primary term";
                seqNo = seqNoField.longValue();
                primaryTerm = primaryTermField.longValue();
            }
            hit.setSeqNo(seqNo);
            hit.setPrimaryTerm(primaryTerm);
        }
    }
}

