/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.suggest.phrase;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.Terms;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.suggest.phrase.DirectCandidateGenerator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.suggest.phrase.WordScorer;

final class LaplaceScorer
extends WordScorer {
    private double alpha;

    LaplaceScorer(IndexReader reader, Terms terms, String field, double realWordLikelihood, BytesRef separator, double alpha) throws IOException {
        super(reader, terms, field, realWordLikelihood, separator);
        this.alpha = alpha;
    }

    double alpha() {
        return this.alpha;
    }

    @Override
    protected double scoreUnigram(DirectCandidateGenerator.Candidate word) throws IOException {
        return (this.alpha + (double)this.frequency(word.term)) / ((double)this.vocabluarySize + this.alpha * (double)this.numTerms);
    }

    @Override
    protected double scoreBigram(DirectCandidateGenerator.Candidate word, DirectCandidateGenerator.Candidate w_1) throws IOException {
        LaplaceScorer.join(this.separator, this.spare, w_1.term, word.term);
        return (this.alpha + (double)this.frequency(this.spare.get())) / ((double)w_1.termStats.totalTermFreq + this.alpha * (double)this.numTerms);
    }

    @Override
    protected double scoreTrigram(DirectCandidateGenerator.Candidate word, DirectCandidateGenerator.Candidate w_1, DirectCandidateGenerator.Candidate w_2) throws IOException {
        LaplaceScorer.join(this.separator, this.spare, w_2.term, w_1.term, word.term);
        long trigramCount = this.frequency(this.spare.get());
        LaplaceScorer.join(this.separator, this.spare, w_1.term, word.term);
        return (this.alpha + (double)trigramCount) / ((double)this.frequency(this.spare.get()) + this.alpha * (double)this.numTerms);
    }
}

