/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import com.google.common.collect.Streams;
import java.util.List;
import java.util.stream.Collectors;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchResponse;
import org.graylog.storage.elasticsearch7.ElasticsearchClient;
import org.graylog2.indexer.results.ChunkedQueryResult;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.indexer.results.ResultMessageFactory;

public abstract class ChunkedQueryResultES7
extends ChunkedQueryResult<ElasticsearchClient, SearchResponse> {
    private final ResultMessageFactory resultMessageFactory;

    public ChunkedQueryResultES7(ResultMessageFactory resultMessageFactory, ElasticsearchClient client, SearchResponse initialResult, String query, List<String> fields, int limit) {
        super((Object)client, (Object)initialResult, query, fields, limit);
        this.resultMessageFactory = resultMessageFactory;
    }

    protected List<ResultMessage> collectMessagesFromResult(SearchResponse response) {
        return Streams.stream((Iterable)response.getHits()).map(hit -> this.resultMessageFactory.parseFromSource(hit.getId(), hit.getIndex(), hit.getSourceAsMap())).collect(Collectors.toList());
    }

    protected long countTotalHits(SearchResponse response) {
        return response.getHits().getTotalHits().value;
    }

    protected long getTookMillisFromResponse(SearchResponse response) {
        return response.getTook().getMillis();
    }
}

