/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.github.joschi.jadconfig.util.Duration;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.cluster.settings.ClusterGetSettingsRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.cluster.settings.ClusterGetSettingsResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Request;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.RequestOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.unit.TimeValue;
import org.graylog.storage.elasticsearch7.ElasticsearchClient;
import org.graylog.storage.elasticsearch7.PlainJsonApi;
import org.graylog.storage.elasticsearch7.cat.CatApi;
import org.graylog.storage.elasticsearch7.cat.IndexSummaryResponse;
import org.graylog.storage.elasticsearch7.cat.NodeResponse;
import org.graylog2.indexer.ElasticsearchException;
import org.graylog2.indexer.cluster.ClusterAdapter;
import org.graylog2.indexer.cluster.PendingTasksStats;
import org.graylog2.indexer.cluster.health.ClusterAllocationDiskSettings;
import org.graylog2.indexer.cluster.health.ClusterAllocationDiskSettingsFactory;
import org.graylog2.indexer.cluster.health.ClusterShardAllocation;
import org.graylog2.indexer.cluster.health.NodeDiskUsageStats;
import org.graylog2.indexer.cluster.health.NodeFileDescriptorStats;
import org.graylog2.indexer.indices.HealthStatus;
import org.graylog2.rest.models.system.indexer.responses.ClusterHealth;
import org.graylog2.system.stats.elasticsearch.ClusterStats;
import org.graylog2.system.stats.elasticsearch.IndicesStats;
import org.graylog2.system.stats.elasticsearch.NodeInfo;
import org.graylog2.system.stats.elasticsearch.NodesStats;
import org.graylog2.system.stats.elasticsearch.ShardStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterAdapterES7
implements ClusterAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterAdapterES7.class);
    private final ElasticsearchClient client;
    private final Duration requestTimeout;
    private final CatApi catApi;
    private final PlainJsonApi jsonApi;

    @Inject
    public ClusterAdapterES7(ElasticsearchClient client, @Named(value="elasticsearch_socket_timeout") Duration requestTimeout, CatApi catApi, PlainJsonApi jsonApi) {
        this.client = client;
        this.requestTimeout = requestTimeout;
        this.catApi = catApi;
        this.jsonApi = jsonApi;
    }

    public Optional<HealthStatus> health() {
        return this.clusterHealth().map(response -> this.healthStatusFrom(response.getStatus()));
    }

    private HealthStatus healthStatusFrom(ClusterHealthStatus status) {
        switch (status) {
            case RED: {
                return HealthStatus.Red;
            }
            case YELLOW: {
                return HealthStatus.Yellow;
            }
            case GREEN: {
                return HealthStatus.Green;
            }
        }
        throw new IllegalStateException("Invalid health status received: " + String.valueOf(status));
    }

    public Set<NodeFileDescriptorStats> fileDescriptorStats() {
        List<NodeResponse> result = this.nodes();
        return result.stream().map(node -> NodeFileDescriptorStats.create((String)node.name(), (String)node.ip(), (String)node.host(), (Long)node.fileDescriptorMax())).collect(Collectors.toSet());
    }

    private List<NodeResponse> nodes() {
        List<NodeResponse> allNodes = this.catApi.nodes();
        List<NodeResponse> nodesWithDiskStatistics = allNodes.stream().filter(NodeResponse::hasDiskStatistics).collect(Collectors.toList());
        if (allNodes.size() != nodesWithDiskStatistics.size()) {
            List<NodeResponse> nodesWithMissingDiskStatistics = allNodes.stream().filter(nr -> !nr.hasDiskStatistics()).collect(Collectors.toList());
            LOG.info("_cat/nodes API has returned " + nodesWithMissingDiskStatistics.size() + " nodes without disk statistics:");
            nodesWithMissingDiskStatistics.forEach(node -> LOG.info(node.toString()));
        }
        return nodesWithDiskStatistics;
    }

    public Set<NodeDiskUsageStats> diskUsageStats() {
        List<NodeResponse> result = this.nodes();
        return result.stream().map(node -> NodeDiskUsageStats.create((String)node.name(), (String)node.role(), (String)node.ip(), (String)node.host(), (String)node.diskUsed(), (String)node.diskTotal(), (Double)node.diskUsedPercent())).collect(Collectors.toSet());
    }

    public ClusterAllocationDiskSettings clusterAllocationDiskSettings() {
        ClusterGetSettingsRequest request = new ClusterGetSettingsRequest();
        request.includeDefaults(true);
        ClusterGetSettingsResponse response = this.client.execute((c, requestOptions) -> c.cluster().getSettings(request, (RequestOptions)requestOptions));
        return ClusterAllocationDiskSettingsFactory.create((boolean)Boolean.parseBoolean(response.getSetting("cluster.routing.allocation.disk.threshold_enabled")), (String)response.getSetting("cluster.routing.allocation.disk.watermark.low"), (String)response.getSetting("cluster.routing.allocation.disk.watermark.high"), (String)response.getSetting("cluster.routing.allocation.disk.watermark.flood_stage"));
    }

    public ClusterShardAllocation clusterShardAllocation() {
        return new ClusterShardAllocation(Integer.MAX_VALUE, List.of());
    }

    public Optional<String> nodeIdToName(String nodeId) {
        return this.nodeById(nodeId).map(jsonNode -> jsonNode.get("name").asText());
    }

    public Optional<String> nodeIdToHostName(String nodeId) {
        return this.nodeById(nodeId).map(jsonNode -> jsonNode.path("host")).filter(host -> !host.isMissingNode()).map(JsonNode::asText);
    }

    private Optional<JsonNode> nodeById(String nodeId) {
        if (Strings.isNullOrEmpty((String)nodeId)) {
            return Optional.empty();
        }
        Request request = new Request("GET", "/_nodes/" + nodeId);
        return Optional.of(this.jsonApi.perform(request, "Unable to retrieve node information for node id " + nodeId)).map(jsonNode -> jsonNode.path("nodes").path(nodeId)).filter(node -> !node.isMissingNode());
    }

    public boolean isConnected() {
        ClusterHealthRequest request = (ClusterHealthRequest)new ClusterHealthRequest().timeout(new TimeValue(this.requestTimeout.getQuantity(), this.requestTimeout.getUnit())).local(true);
        try {
            ClusterHealthResponse result = this.client.execute((c, requestOptions) -> c.cluster().health(request, (RequestOptions)requestOptions));
            return result.getNumberOfDataNodes() > 0;
        }
        catch (org.graylog.shaded.elasticsearch7.org.elasticsearch.ElasticsearchException e) {
            LOG.error("Check for connectivity failed with exception '{}' - enable debug level for this class to see the stack trace.", (Object)e.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            return false;
        }
    }

    public Optional<String> clusterName() {
        return this.clusterHealth().map(ClusterHealthResponse::getClusterName);
    }

    public Optional<ClusterHealth> clusterHealthStats() {
        return this.clusterHealth().map(this::clusterHealthFrom);
    }

    private ClusterHealth clusterHealthFrom(ClusterHealthResponse response) {
        return ClusterHealth.create((String)response.getStatus().toString().toLowerCase(Locale.ENGLISH), (ClusterHealth.ShardStatus)ClusterHealth.ShardStatus.create((int)response.getActiveShards(), (int)response.getInitializingShards(), (int)response.getRelocatingShards(), (int)response.getUnassignedShards()));
    }

    public PendingTasksStats pendingTasks() {
        Request request = new Request("GET", "/_cluster/pending_tasks");
        JsonNode response = this.jsonApi.perform(request, "Couldn't read Elasticsearch pending cluster tasks");
        JsonNode pendingClusterTasks = response.path("tasks");
        int pendingTasksSize = pendingClusterTasks.size();
        ArrayList pendingTasksTimeInQueue = Lists.newArrayListWithCapacity((int)pendingTasksSize);
        for (JsonNode jsonElement : pendingClusterTasks) {
            if (!jsonElement.has("time_in_queue_millis")) continue;
            pendingTasksTimeInQueue.add(jsonElement.get("time_in_queue_millis").asLong());
        }
        return PendingTasksStats.create((int)pendingTasksSize, (List)pendingTasksTimeInQueue);
    }

    public ClusterStats clusterStats() {
        ArrayNode versions;
        JsonNode versionNode;
        JsonNode clusterStatsResponseJson = this.rawClusterStats();
        String clusterName = clusterStatsResponseJson.path("cluster_name").asText();
        String clusterVersion = null;
        if (clusterStatsResponseJson.path("nodes").path("versions").isArray() && (versionNode = (versions = (ArrayNode)clusterStatsResponseJson.path("nodes").path("versions")).path(0)).getNodeType() != JsonNodeType.MISSING) {
            clusterVersion = versionNode.asText();
        }
        JsonNode countStats = clusterStatsResponseJson.path("nodes").path("count");
        NodesStats nodesStats = NodesStats.create((int)countStats.path("total").asInt(-1), (int)countStats.path("master_only").asInt(-1), (int)countStats.path("data_only").asInt(-1), (int)countStats.path("master_data").asInt(-1), (int)countStats.path("client").asInt(-1));
        JsonNode clusterIndicesStats = clusterStatsResponseJson.path("indices");
        IndicesStats indicesStats = IndicesStats.create((int)clusterIndicesStats.path("count").asInt(-1), (long)clusterIndicesStats.path("store").path("size_in_bytes").asLong(-1L), (long)clusterIndicesStats.path("fielddata").path("memory_size_in_bytes").asLong(-1L));
        return ClusterStats.create((String)clusterName, (String)clusterVersion, (NodesStats)nodesStats, (IndicesStats)indicesStats);
    }

    public JsonNode rawClusterStats() {
        Request request = new Request("GET", "/_cluster/stats/nodes/*");
        return this.jsonApi.perform(request, "Couldn't read Elasticsearch cluster stats");
    }

    public Map<String, NodeInfo> nodesInfo() {
        Request request = new Request("GET", "/_nodes");
        JsonNode nodesJson = this.jsonApi.perform(request, "Couldn't read Elasticsearch nodes data!");
        return this.toStream(nodesJson.at("/nodes").fields()).collect(Collectors.toMap(Map.Entry::getKey, o -> this.createNodeInfo((JsonNode)o.getValue())));
    }

    private NodeInfo createNodeInfo(JsonNode nodesJson) {
        return NodeInfo.builder().version(nodesJson.at("/version").asText()).os((Object)nodesJson.at("/os")).roles(this.toStream(nodesJson.at("/roles").elements()).map(JsonNode::asText).toList()).jvmMemHeapMaxInBytes(Long.valueOf(nodesJson.at("/jvm/mem/heap_max_in_bytes").asLong())).build();
    }

    public <T> Stream<T> toStream(Iterator<T> iterator) {
        return StreamSupport.stream(((Iterable)() -> iterator).spliterator(), false);
    }

    public ShardStats shardStats() {
        return this.clusterHealth().map(response -> ShardStats.create((int)response.getNumberOfNodes(), (int)response.getNumberOfDataNodes(), (int)response.getActiveShards(), (int)response.getRelocatingShards(), (int)response.getActivePrimaryShards(), (int)response.getInitializingShards(), (int)response.getUnassignedShards(), (boolean)response.isTimedOut())).orElseThrow(() -> new ElasticsearchException("Unable to retrieve shard stats."));
    }

    private Optional<ClusterHealthResponse> clusterHealth() {
        try {
            ClusterHealthRequest request = new ClusterHealthRequest().timeout(TimeValue.timeValueSeconds(Ints.saturatedCast((long)this.requestTimeout.toSeconds())));
            return Optional.of(this.client.execute((c, requestOptions) -> c.cluster().health(request, (RequestOptions)requestOptions)));
        }
        catch (org.graylog.shaded.elasticsearch7.org.elasticsearch.ElasticsearchException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error("{} ({})", new Object[]{e.getMessage(), Optional.ofNullable(e.getCause()).map(Throwable::getMessage).orElse("n/a"), e});
            } else {
                LOG.error("{} ({})", (Object)e.getMessage(), (Object)Optional.ofNullable(e.getCause()).map(Throwable::getMessage).orElse("n/a"));
            }
            return Optional.empty();
        }
    }

    public Optional<HealthStatus> deflectorHealth(Collection<String> indices) {
        if (indices.isEmpty()) {
            return Optional.of(HealthStatus.Green);
        }
        Map<String, String> aliasMapping = this.catApi.aliases();
        Set mappedIndices = indices.stream().map(index -> aliasMapping.getOrDefault(index, (String)index)).collect(Collectors.toSet());
        Set indexSummaries = this.catApi.indices().stream().filter(indexSummary -> mappedIndices.contains(indexSummary.index())).collect(Collectors.toSet());
        if (indexSummaries.size() < mappedIndices.size()) {
            return Optional.empty();
        }
        return indexSummaries.stream().map(IndexSummaryResponse::health).map(HealthStatus::fromString).min(Enum::compareTo);
    }
}

