/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.RequestOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.indices.ComposableIndexTemplateExistRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.indices.DeleteComposableIndexTemplateRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.indices.PutComposableIndexTemplateRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.compress.CompressedXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentType;
import org.graylog.storage.elasticsearch7.ElasticsearchClient;
import org.graylog.storage.elasticsearch7.IndexTemplateAdapter;
import org.graylog2.indexer.indices.Template;

public class ComposableIndexTemplateAdapter
implements IndexTemplateAdapter {
    private final ElasticsearchClient client;
    private final ObjectMapper objectMapper;

    @Inject
    public ComposableIndexTemplateAdapter(ElasticsearchClient client, ObjectMapper objectMapper) {
        this.client = client;
        this.objectMapper = objectMapper;
    }

    @Override
    public boolean ensureIndexTemplate(String templateName, Template template) {
        CompressedXContent serializedMapping = this.serialize(template.mappings());
        Settings settings = Settings.builder().loadFromSource(this.serializeJson(template.settings()), XContentType.JSON).build();
        org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.Template esTemplate = new org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.Template(settings, serializedMapping, null);
        ComposableIndexTemplate indexTemplate = new ComposableIndexTemplate(template.indexPatterns(), esTemplate, null, template.order(), null, null);
        PutComposableIndexTemplateRequest request = new PutComposableIndexTemplateRequest().name(templateName).indexTemplate(indexTemplate);
        AcknowledgedResponse result = this.client.execute((c, requestOptions) -> c.indices().putIndexTemplate(request, (RequestOptions)requestOptions), "Unable to create index template " + templateName);
        return result.isAcknowledged();
    }

    private String serializeJson(Object obj) {
        try {
            return this.objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private CompressedXContent serialize(Object obj) {
        try {
            return new CompressedXContent(this.serializeJson(obj));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean indexTemplateExists(String templateName) {
        return this.client.execute((c, requestOptions) -> c.indices().existsIndexTemplate(new ComposableIndexTemplateExistRequest(templateName), (RequestOptions)requestOptions), "Unable to verify index template existence " + templateName);
    }

    @Override
    public boolean deleteIndexTemplate(String templateName) {
        DeleteComposableIndexTemplateRequest request = new DeleteComposableIndexTemplateRequest(templateName);
        AcknowledgedResponse result = this.client.execute((c, requestOptions) -> c.indices().deleteIndexTemplate(request, (RequestOptions)requestOptions), "Unable to delete index template " + templateName);
        return result.isAcknowledged();
    }
}

