/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.text.Text;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.SearchHit;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.indexer.results.ResultMessageFactory;

public class ES7ResultMessageFactory {
    private final ResultMessageFactory messageFactory;

    @Inject
    public ES7ResultMessageFactory(ResultMessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    public ResultMessage fromSearchHit(SearchHit hit) {
        Map<String, List> highlights = hit.getHighlightFields().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, ES7ResultMessageFactory::highlightsFromFragments));
        return this.messageFactory.parseFromSource(hit.getId(), hit.getIndex(), hit.getSourceAsMap(), highlights);
    }

    private static List<String> highlightsFromFragments(Map.Entry<String, HighlightField> entry) {
        return Arrays.stream(entry.getValue().fragments()).map(Text::toString).collect(Collectors.toList());
    }
}

