/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import com.github.zafarkhaja.semver.Version;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.Collection;
import org.graylog.storage.elasticsearch7.Elasticsearch7Metadata;
import org.graylog.storage.elasticsearch7.Elasticsearch7Module;
import org.graylog.storage.elasticsearch7.ViewsESBackendModule;
import org.graylog2.featureflag.FeatureFlags;
import org.graylog2.plugin.Plugin;
import org.graylog2.plugin.PluginMetaData;
import org.graylog2.plugin.PluginModule;
import org.graylog2.storage.SearchVersion;

public class Elasticsearch7Plugin
implements Plugin {
    public static final SearchVersion SUPPORTED_ES_VERSION = SearchVersion.elasticsearch((int)7, (int)0, (int)0);
    public static final SearchVersion SUPPORTED_OPENSEARCH_VERSION = SearchVersion.create((SearchVersion.Distribution)SearchVersion.Distribution.OPENSEARCH, (Version)Version.of((long)1L, (long)0L, (long)0L));
    @Inject
    private FeatureFlags featureFlags;

    public PluginMetaData metadata() {
        return new Elasticsearch7Metadata();
    }

    public Collection<PluginModule> modules() {
        boolean useComposableIndexTemplates = this.featureFlags.isOn("composable_index_templates");
        return ImmutableSet.of((Object)((Object)new Elasticsearch7Module(SUPPORTED_ES_VERSION, useComposableIndexTemplates)), (Object)((Object)new ViewsESBackendModule(SUPPORTED_ES_VERSION)), (Object)((Object)new Elasticsearch7Module(SUPPORTED_OPENSEARCH_VERSION, useComposableIndexTemplates)), (Object)((Object)new ViewsESBackendModule(SUPPORTED_OPENSEARCH_VERSION)));
    }
}

