/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.joschi.jadconfig.util.Duration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog.shaded.elasticsearch7.org.apache.http.ContentTooLongException;
import org.graylog.shaded.elasticsearch7.org.apache.http.client.config.RequestConfig;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ElasticsearchStatusException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.MultiSearchRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.MultiSearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.PlainActionFuture;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Request;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.RequestOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Response;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ResponseException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.RestHighLevelClient;
import org.graylog.storage.elasticsearch7.ParsedElasticsearchException;
import org.graylog.storage.elasticsearch7.ThrowingBiFunction;
import org.graylog.storage.errors.ResponseError;
import org.graylog2.indexer.BatchSizeTooLargeException;
import org.graylog2.indexer.IndexNotFoundException;
import org.graylog2.indexer.InvalidWriteTargetException;
import org.graylog2.indexer.MapperParsingException;
import org.graylog2.indexer.MasterNotDiscoveredException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchClient {
    private static final Pattern invalidWriteTarget = Pattern.compile("no write index is defined for alias \\[(?<target>[\\w_]+)\\]");
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchClient.class);
    private final RestHighLevelClient client;
    private final boolean compressionEnabled;
    private final Optional<Integer> indexerMaxConcurrentSearches;
    private final Optional<Integer> indexerMaxConcurrentShardRequests;
    private final ObjectMapper objectMapper;

    @Inject
    public ElasticsearchClient(RestHighLevelClient client, @Named(value="elasticsearch_compression_enabled") boolean compressionEnabled, @Named(value="indexer_max_concurrent_searches") @Nullable Integer indexerMaxConcurrentSearches, @Named(value="indexer_max_concurrent_shard_requests") @Nullable Integer indexerMaxConcurrentShardRequests, ObjectMapper objectMapper) {
        this.client = client;
        this.compressionEnabled = compressionEnabled;
        this.indexerMaxConcurrentSearches = Optional.ofNullable(indexerMaxConcurrentSearches);
        this.indexerMaxConcurrentShardRequests = Optional.ofNullable(indexerMaxConcurrentShardRequests);
        this.objectMapper = objectMapper;
    }

    @VisibleForTesting
    public ElasticsearchClient(RestHighLevelClient client, ObjectMapper objectMapper) {
        this(client, false, null, null, objectMapper);
    }

    public SearchResponse search(SearchRequest searchRequest, String errorMessage) {
        MultiSearchRequest multiSearchRequest = new MultiSearchRequest().add(searchRequest);
        MultiSearchResponse result = this.execute((c, requestOptions) -> c.msearch(multiSearchRequest, (RequestOptions)requestOptions), errorMessage);
        return this.firstResponseFrom(result, errorMessage);
    }

    public SearchResponse singleSearch(SearchRequest searchRequest, String errorMessage) {
        return this.execute((c, requestOptions) -> c.search(searchRequest, (RequestOptions)requestOptions), errorMessage);
    }

    public List<MultiSearchResponse.Item> msearch(List<SearchRequest> searchRequests, String errorMessage) {
        MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
        this.indexerMaxConcurrentSearches.ifPresent(multiSearchRequest::maxConcurrentSearchRequests);
        this.indexerMaxConcurrentShardRequests.ifPresent(maxShardRequests -> searchRequests.forEach(request -> request.setMaxConcurrentShardRequests((int)maxShardRequests)));
        searchRequests.forEach(multiSearchRequest::add);
        MultiSearchResponse result = this.execute((c, requestOptions) -> c.msearch(multiSearchRequest, (RequestOptions)requestOptions), errorMessage);
        return Streams.stream((Iterable)result).collect(Collectors.toList());
    }

    private SearchResponse firstResponseFrom(MultiSearchResponse result, String errorMessage) {
        Preconditions.checkArgument((result != null ? 1 : 0) != 0);
        Preconditions.checkArgument((result.getResponses().length == 1 ? 1 : 0) != 0);
        MultiSearchResponse.Item firstResponse = result.getResponses()[0];
        if (firstResponse.getResponse() == null) {
            throw ElasticsearchClient.exceptionFrom(firstResponse.getFailure(), errorMessage);
        }
        return firstResponse.getResponse();
    }

    public PlainActionFuture<MultiSearchResponse> cancellableMsearch(List<SearchRequest> searchRequests) {
        MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
        this.indexerMaxConcurrentSearches.ifPresent(multiSearchRequest::maxConcurrentSearchRequests);
        this.indexerMaxConcurrentShardRequests.ifPresent(maxShardRequests -> searchRequests.forEach(request -> request.setMaxConcurrentShardRequests((int)maxShardRequests)));
        searchRequests.forEach(multiSearchRequest::add);
        PlainActionFuture<MultiSearchResponse> future = new PlainActionFuture<MultiSearchResponse>();
        this.client.msearchAsync(multiSearchRequest, this.requestOptions(), future);
        return future;
    }

    public <R> R execute(ThrowingBiFunction<RestHighLevelClient, RequestOptions, R, IOException> fn) {
        return this.execute(fn, "An error occurred: ");
    }

    @WithSpan
    public <R> R execute(ThrowingBiFunction<RestHighLevelClient, RequestOptions, R, IOException> fn, String errorMessage) {
        try {
            return fn.apply(this.client, this.requestOptions());
        }
        catch (Exception e) {
            throw ElasticsearchClient.exceptionFrom(e, errorMessage);
        }
    }

    @WithSpan
    public <R> R executeWithIOException(ThrowingBiFunction<RestHighLevelClient, RequestOptions, R, IOException> fn, String errorMessage) throws IOException {
        try {
            return fn.apply(this.client, this.requestOptions());
        }
        catch (IOException e) {
            if (e.getCause() instanceof ContentTooLongException) {
                throw new BatchSizeTooLargeException(e.getMessage());
            }
            throw e;
        }
        catch (Exception e) {
            throw ElasticsearchClient.exceptionFrom(e, errorMessage);
        }
    }

    public JsonNode executeRequest(Request request, String errorMessage) {
        return this.execute((c, requestOptions) -> {
            Response response = c.getLowLevelClient().performRequest(request);
            return this.objectMapper.readTree(response.getEntity().getContent());
        }, errorMessage);
    }

    private RequestOptions requestOptions() {
        return this.compressionEnabled ? RequestOptions.DEFAULT.toBuilder().addHeader("Accept-Encoding", "gzip").addHeader("Content-type", "application/json").build() : RequestOptions.DEFAULT;
    }

    public static RuntimeException exceptionFrom(Exception e, String errorMessage) {
        if (e instanceof ElasticsearchException) {
            Matcher matcher;
            ElasticsearchException elasticsearchException = (ElasticsearchException)e;
            if (ElasticsearchClient.isIndexNotFoundException(elasticsearchException)) {
                return IndexNotFoundException.create((String)(errorMessage + String.valueOf(elasticsearchException.getResourceId())), (String)elasticsearchException.getIndex().getName());
            }
            if (ElasticsearchClient.isMasterNotDiscoveredException(elasticsearchException)) {
                return new MasterNotDiscoveredException();
            }
            if (ElasticsearchClient.isInvalidWriteTargetException(elasticsearchException) && (matcher = invalidWriteTarget.matcher(elasticsearchException.getMessage())).find()) {
                String target = matcher.group("target");
                return InvalidWriteTargetException.create((String)target);
            }
            if (ElasticsearchClient.isBatchSizeTooLargeException(elasticsearchException)) {
                return new BatchSizeTooLargeException(elasticsearchException.getMessage());
            }
            if (ElasticsearchClient.isMapperParsingExceptionException(elasticsearchException)) {
                return new MapperParsingException(elasticsearchException.getMessage());
            }
        } else if (e instanceof IOException && e.getCause() instanceof ContentTooLongException) {
            return new BatchSizeTooLargeException(e.getMessage());
        }
        return new ElasticsearchException(errorMessage, (Throwable)e, new Object[0]);
    }

    private static boolean isInvalidWriteTargetException(ElasticsearchException elasticsearchException) {
        try {
            ParsedElasticsearchException parsedException = ParsedElasticsearchException.from(elasticsearchException.getMessage());
            return parsedException.reason().startsWith("no write index is defined for alias");
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isMasterNotDiscoveredException(ElasticsearchException elasticsearchException) {
        try {
            ParsedElasticsearchException parsedException = ParsedElasticsearchException.from(elasticsearchException.getMessage());
            return parsedException.type().equals("master_not_discovered_exception") || parsedException.type().equals("cluster_block_exception") && parsedException.reason().contains("no master");
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isIndexNotFoundException(ElasticsearchException elasticsearchException) {
        return elasticsearchException.getMessage().contains("index_not_found_exception");
    }

    private static boolean isMapperParsingExceptionException(ElasticsearchException openSearchException) {
        return openSearchException.getMessage().contains("mapper_parsing_exception");
    }

    private static boolean isBatchSizeTooLargeException(ElasticsearchException elasticsearchException) {
        ElasticsearchStatusException statusException;
        Throwable throwable;
        if (elasticsearchException instanceof ElasticsearchStatusException && (throwable = (statusException = (ElasticsearchStatusException)elasticsearchException).getCause()) instanceof ResponseException) {
            ResponseException responseException = (ResponseException)throwable;
            return responseException.getResponse().getStatusLine().getStatusCode() == 429;
        }
        try {
            ParsedElasticsearchException parsedException = ParsedElasticsearchException.from(elasticsearchException.getMessage());
            if (parsedException.type().equals("search_phase_execution_exception")) {
                ParsedElasticsearchException parsedCause = ParsedElasticsearchException.from(elasticsearchException.getRootCause().getMessage());
                return parsedCause.reason().contains("Batch size is too large");
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static RequestOptions withTimeout(RequestOptions requestOptions, Duration timeout) {
        RequestConfig.Builder requestConfigBuilder = requestOptions == null || requestOptions.getRequestConfig() == null ? RequestConfig.custom() : RequestConfig.copy(requestOptions.getRequestConfig());
        RequestConfig requestConfigWithTimeout = requestConfigBuilder.setSocketTimeout(Math.toIntExact(timeout.toMilliseconds())).build();
        RequestOptions.Builder requestOptionsBuilder = requestOptions == null ? RequestOptions.DEFAULT.toBuilder() : requestOptions.toBuilder();
        return requestOptionsBuilder.setRequestConfig(requestConfigWithTimeout).build();
    }

    public Optional<ResponseError> parseResponseException(ElasticsearchException ex) {
        Throwable realCause;
        Throwable[] suppressed;
        if (ex.getCause() != null && (suppressed = ex.getCause().getSuppressed()).length > 0 && (realCause = suppressed[0]) instanceof ResponseException) {
            try {
                ResponseError err = (ResponseError)this.objectMapper.readValue(((ResponseException)realCause).getResponse().getEntity().getContent(), ResponseError.class);
                return Optional.of(err);
            }
            catch (IOException ioe) {
                LOG.warn("Failed to parse exception", (Throwable)ioe);
            }
        }
        return Optional.empty();
    }
}

