/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Node;
import org.graylog.storage.elasticsearch7.NodesSniffer;

class FilteredElasticsearchNodesSniffer
implements NodesSniffer {
    private final String attribute;
    private final String value;

    static FilteredElasticsearchNodesSniffer create(String filter) {
        String value;
        String attribute;
        if (!Strings.isNullOrEmpty((String)filter)) {
            String[] conditions = filter.split(":");
            if (conditions.length < 2) {
                throw new IllegalArgumentException("Invalid filter specified for ES node discovery: " + filter);
            }
            attribute = conditions[0].trim();
            value = conditions[1].trim();
        } else {
            attribute = null;
            value = null;
        }
        return new FilteredElasticsearchNodesSniffer(attribute, value);
    }

    @VisibleForTesting
    FilteredElasticsearchNodesSniffer(String attribute, String value) {
        this.attribute = attribute;
        this.value = value;
    }

    @Override
    public List<Node> sniff(List<Node> nodes) {
        if (this.attribute == null || this.value == null) {
            return nodes;
        }
        return nodes.stream().filter(node -> this.nodeMatchesFilter((Node)node, this.attribute, this.value)).collect(Collectors.toList());
    }

    private boolean nodeMatchesFilter(Node node, String attribute, String value) {
        return node.getAttributes().getOrDefault(attribute, Collections.emptyList()).contains(value);
    }
}

