/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import com.codahale.metrics.Timer;
import com.google.common.collect.Iterables;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog.storage.elasticsearch7.mapping.FieldMappingApi;
import org.graylog2.Configuration;
import org.graylog2.indexer.IndexNotFoundException;
import org.graylog2.indexer.fieldtypes.FieldTypeDTO;
import org.graylog2.indexer.fieldtypes.IndexFieldTypePollerAdapter;
import org.graylog2.indexer.fieldtypes.streamfiltered.esadapters.StreamsForFieldRetriever;
import org.graylog2.shared.utilities.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexFieldTypePollerAdapterES7
implements IndexFieldTypePollerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(IndexFieldTypePollerAdapterES7.class);
    private final FieldMappingApi fieldMappingApi;
    private final boolean streamAwareFieldTypes;
    private final StreamsForFieldRetriever streamsForFieldRetriever;

    @Inject
    public IndexFieldTypePollerAdapterES7(FieldMappingApi fieldMappingApi, Configuration configuration, StreamsForFieldRetriever streamsForFieldRetriever) {
        this.fieldMappingApi = fieldMappingApi;
        this.streamAwareFieldTypes = configuration.maintainsStreamAwareFieldTypes();
        this.streamsForFieldRetriever = streamsForFieldRetriever;
    }

    public Optional<Set<FieldTypeDTO>> pollIndex(String indexName, Timer pollTimer) {
        Map<String, FieldMappingApi.FieldMapping> fieldTypes;
        try (Timer.Context ignored = pollTimer.time();){
            fieldTypes = this.fieldMappingApi.fieldTypes(indexName);
        }
        catch (IndexNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error("Couldn't get mapping for index <{}>", (Object)indexName, (Object)e);
            } else {
                LOG.error("Couldn't get mapping for index <{}>: {}", (Object)indexName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
            return Optional.empty();
        }
        Map<String, FieldMappingApi.FieldMapping> filteredFieldTypes = fieldTypes.entrySet().stream().filter(field -> !((FieldMappingApi.FieldMapping)field.getValue()).type().isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (!this.streamAwareFieldTypes) {
            return Optional.of(filteredFieldTypes.entrySet().stream().map(field -> this.fromFieldNameAndMapping((String)field.getKey(), (FieldMappingApi.FieldMapping)field.getValue()).streams(Set.of()).build()).collect(Collectors.toSet()));
        }
        HashSet result = new HashSet();
        Iterable partitioned = Iterables.partition(filteredFieldTypes.entrySet(), (int)50);
        for (List batch : partitioned) {
            Map streams = this.streamsForFieldRetriever.getStreams(batch.stream().map(Map.Entry::getKey).collect(Collectors.toList()), indexName);
            batch.stream().map(entry -> this.fromFieldNameAndMapping((String)entry.getKey(), (FieldMappingApi.FieldMapping)entry.getValue()).streams((Set)streams.get(entry.getKey())).build()).forEach(result::add);
        }
        return Optional.of(result);
    }

    private FieldTypeDTO.Builder fromFieldNameAndMapping(String fieldName, FieldMappingApi.FieldMapping mapping) {
        Boolean fieldData = mapping.fielddata().orElse(false);
        return FieldTypeDTO.builder().fieldName(fieldName).physicalType(mapping.type()).properties(fieldData != false ? Collections.singleton(FieldTypeDTO.Properties.FIELDDATA) : Set.of());
    }

    public boolean maintainsStreamBasedFieldLists() {
        return this.streamAwareFieldTypes;
    }
}

