/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.joschi.jadconfig.util.Duration;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.IndicesOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.GetAliasesResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.RequestOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Requests;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.indices.CloseIndexRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.indices.CreateIndexRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.indices.DeleteAliasRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.indices.GetMappingsRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.indices.PutMappingRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.AliasMetadata;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.bytes.BytesReference;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentFactory;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentHelper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.reindex.ReindexRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.filter.Filter;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.Max;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.Min;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.storage.elasticsearch7.ElasticsearchClient;
import org.graylog.storage.elasticsearch7.IndexTemplateAdapter;
import org.graylog.storage.elasticsearch7.blocks.BlockSettingsParser;
import org.graylog.storage.elasticsearch7.cat.CatApi;
import org.graylog.storage.elasticsearch7.cluster.ClusterStateApi;
import org.graylog.storage.elasticsearch7.stats.ClusterStatsApi;
import org.graylog.storage.elasticsearch7.stats.StatsApi;
import org.graylog2.datatiering.WarmIndexInfo;
import org.graylog2.indexer.IndexNotFoundException;
import org.graylog2.indexer.indices.HealthStatus;
import org.graylog2.indexer.indices.IndexMoveResult;
import org.graylog2.indexer.indices.IndexSettings;
import org.graylog2.indexer.indices.IndicesAdapter;
import org.graylog2.indexer.indices.ShardsInfo;
import org.graylog2.indexer.indices.Template;
import org.graylog2.indexer.indices.blocks.IndicesBlockStatus;
import org.graylog2.indexer.indices.stats.IndexStatistics;
import org.graylog2.indexer.searches.IndexRangeStats;
import org.graylog2.rest.resources.system.indexer.responses.IndexSetStats;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndicesAdapterES7
implements IndicesAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(IndicesAdapterES7.class);
    private final ElasticsearchClient client;
    private final StatsApi statsApi;
    private final ClusterStatsApi clusterStatsApi;
    private final CatApi catApi;
    private final ClusterStateApi clusterStateApi;
    private final IndexTemplateAdapter indexTemplateAdapter;
    private final int MAX_INDICES_URL_LENGTH = 3000;

    @Inject
    public IndicesAdapterES7(ElasticsearchClient client, StatsApi statsApi, ClusterStatsApi clusterStatsApi, CatApi catApi, ClusterStateApi clusterStateApi, IndexTemplateAdapter indexTemplateAdapter) {
        this.client = client;
        this.statsApi = statsApi;
        this.clusterStatsApi = clusterStatsApi;
        this.catApi = catApi;
        this.clusterStateApi = clusterStateApi;
        this.indexTemplateAdapter = indexTemplateAdapter;
    }

    public void move(String source, String target, Consumer<IndexMoveResult> resultCallback) {
        ReindexRequest request = new ReindexRequest();
        request.setSourceIndices(source);
        request.setDestIndex(target);
        BulkByScrollResponse result = this.client.execute((c, requestOptions) -> c.reindex(request, (RequestOptions)requestOptions));
        IndexMoveResult indexMoveResult = IndexMoveResult.create((int)Math.toIntExact(result.getTotal()), (long)result.getTook().millis(), (!result.getBulkFailures().isEmpty() ? 1 : 0) != 0);
        resultCallback.accept(indexMoveResult);
    }

    public void delete(String index) {
        DeleteIndexRequest request = new DeleteIndexRequest(index);
        this.client.execute((c, requestOptions) -> c.indices().delete(request, (RequestOptions)requestOptions));
    }

    public Set<String> resolveAlias(String alias) {
        GetAliasesRequest request = new GetAliasesRequest().aliases(alias);
        GetAliasesResponse result = this.client.execute((c, requestOptions) -> c.indices().getAlias(request, (RequestOptions)requestOptions));
        return result.getAliases().keySet();
    }

    public void create(String index, IndexSettings indexSettings) {
        this.executeCreateIndexRequest(index, this.createIndexRequest(index, indexSettings, null));
    }

    public void create(String index, IndexSettings indexSettings, @Nullable Map<String, Object> mapping) {
        this.executeCreateIndexRequest(index, this.createIndexRequest(index, indexSettings, mapping));
    }

    private CreateIndexRequest createIndexRequest(String index, IndexSettings indexSettings, @Nullable Map<String, Object> mapping) {
        CreateIndexRequest request = new CreateIndexRequest(index).settings(indexSettings.map());
        if (mapping != null) {
            request = request.mapping(mapping);
        }
        return request;
    }

    private void executeCreateIndexRequest(String index, CreateIndexRequest request) {
        this.client.execute((c, requestOptions) -> c.indices().create(request, (RequestOptions)requestOptions), "Unable to create index " + index);
    }

    public void updateIndexMapping(@Nonnull String indexName, @Nonnull String mappingType, @Nonnull Map<String, Object> mapping) {
        PutMappingRequest request = new PutMappingRequest(indexName).source(mapping);
        this.client.execute((c, requestOptions) -> c.indices().putMapping(request, (RequestOptions)requestOptions), "Unable to update index mapping " + indexName);
    }

    public Map<String, Object> getIndexMapping(@Nonnull String index) {
        GetMappingsRequest request = new GetMappingsRequest().indices(index).indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
        return this.client.execute((c, requestOptions) -> c.indices().getMapping(request, (RequestOptions)requestOptions).mappings().get(index).sourceAsMap(), "Couldn't read mapping of index " + index);
    }

    public Map<String, Object> getStructuredIndexSettings(@Nonnull String index) {
        GetSettingsRequest getSettingsRequest = new GetSettingsRequest().indices(index).indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
        return this.client.execute((c, requestOptions) -> {
            GetSettingsResponse settingsResponse = c.indices().getSettings(getSettingsRequest, (RequestOptions)requestOptions);
            Settings settings = settingsResponse.getIndexToSettings().get(index);
            XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
            xContentBuilder.startObject();
            settings.toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
            xContentBuilder.endObject();
            BytesReference bytes = BytesReference.bytes(xContentBuilder);
            return XContentHelper.convertToMap(bytes, true, xContentBuilder.contentType()).v2();
        }, "Couldn't read settings of index " + index);
    }

    public void updateIndexMetaData(@Nonnull String index, @Nonnull Map<String, Object> metadata, boolean mergeExisting) {
        HashMap<String, Object> metaUpdate = new HashMap<String, Object>();
        if (mergeExisting) {
            Map<String, Object> oldMetaData = this.getIndexMetaData(index);
            metaUpdate.putAll(oldMetaData);
        }
        metaUpdate.putAll(metadata);
        this.updateIndexMapping(index, "ignored", Map.of("_meta", metaUpdate));
    }

    public Map<String, Object> getIndexMetaData(@Nonnull String index) {
        Object metaData = this.getIndexMapping(index).get("_meta");
        if (metaData instanceof Map) {
            Map map = (Map)metaData;
            return map;
        }
        return Map.of();
    }

    public boolean ensureIndexTemplate(String templateName, Template template) {
        return this.indexTemplateAdapter.ensureIndexTemplate(templateName, template);
    }

    public boolean indexTemplateExists(String templateName) {
        return this.indexTemplateAdapter.indexTemplateExists(templateName);
    }

    public boolean deleteIndexTemplate(String templateName) {
        return this.indexTemplateAdapter.deleteIndexTemplate(templateName);
    }

    public Optional<DateTime> indexCreationDate(String index) {
        GetSettingsRequest request = new GetSettingsRequest().indices(index).indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
        GetSettingsResponse result = this.client.execute((c, requestOptions) -> c.indices().getSettings(request, (RequestOptions)requestOptions), "Couldn't read settings of index " + index);
        Optional<String> creationDate = Optional.ofNullable(result.getIndexToSettings().get(index)).map(indexSettings -> indexSettings.get("index.creation_date"));
        return creationDate.map(Long::valueOf).map(instant -> new DateTime(instant, DateTimeZone.UTC));
    }

    public Optional<DateTime> indexClosingDate(String index) {
        Map<String, Object> indexMetaData = this.getIndexMetaData(index);
        return Optional.ofNullable(indexMetaData.get("closing_date")).filter(Long.class::isInstance).map(Long.class::cast).map(instant -> new DateTime(instant, DateTimeZone.UTC));
    }

    public void openIndex(String index) {
        OpenIndexRequest request = new OpenIndexRequest(index);
        this.client.execute((c, requestOptions) -> c.indices().open(request, (RequestOptions)requestOptions), "Unable to open index " + index);
    }

    public void setReadOnly(String index) {
        ImmutableMap settings = ImmutableMap.of((Object)"index", (Object)ImmutableMap.of((Object)"blocks", (Object)ImmutableMap.of((Object)"write", (Object)true, (Object)"read", (Object)false, (Object)"metadata", (Object)false)));
        UpdateSettingsRequest request = new UpdateSettingsRequest(index).settings((Map<String, ?>)settings);
        this.client.execute((c, requestOptions) -> c.indices().putSettings(request, (RequestOptions)requestOptions), "Couldn't set index " + index + " to read-only");
    }

    public void flush(String index) {
        FlushRequest request = new FlushRequest(index);
        this.client.execute((c, requestOptions) -> c.indices().flush(request, (RequestOptions)requestOptions), "Unable to flush index " + index);
    }

    public void markIndexReopened(String index) {
        String aliasName = index + "_reopened";
        IndicesAliasesRequest indicesAliasesRequest = new IndicesAliasesRequest();
        IndicesAliasesRequest.AliasActions aliasAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD).index(index).alias(aliasName);
        indicesAliasesRequest.addAliasAction(aliasAction);
        this.client.execute((c, requestOptions) -> c.indices().updateAliases(indicesAliasesRequest, (RequestOptions)requestOptions), "Couldn't create reopened alias for index " + index);
    }

    public void removeAlias(String index, String alias) {
        DeleteAliasRequest request = new DeleteAliasRequest(index, alias);
        this.client.execute((c, requestOptions) -> c.indices().deleteAlias(request, (RequestOptions)requestOptions), "Unable to remove alias " + alias + ", pointing to " + index);
    }

    public void close(String index) {
        CloseIndexRequest request = new CloseIndexRequest(index);
        this.client.execute((c, requestOptions) -> c.indices().close(request, (RequestOptions)requestOptions), "Unable to close index " + index);
    }

    public long numberOfMessages(String index) {
        JsonNode result = this.statsApi.indexStats(index);
        JsonNode count = result.path("_all").path("primaries").path("docs").path("count");
        if (count.isMissingNode()) {
            throw new RuntimeException("Unable to extract count from response.");
        }
        return count.asLong();
    }

    private GetSettingsResponse settingsFor(String indexOrAlias) {
        GetSettingsRequest request = new GetSettingsRequest().indices(indexOrAlias).indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED);
        return this.client.execute((c, requestOptions) -> c.indices().getSettings(request, (RequestOptions)requestOptions), "Unable to retrieve settings for index/alias " + indexOrAlias);
    }

    public Map<String, Set<String>> aliases(String indexPattern) {
        GetAliasesRequest request = new GetAliasesRequest().indices(indexPattern).indicesOptions(IndicesOptions.fromOptions(false, false, true, false));
        GetAliasesResponse result = this.client.execute((c, requestOptions) -> c.indices().getAlias(request, (RequestOptions)requestOptions), "Couldn't collect aliases for index pattern " + indexPattern);
        return result.getAliases().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Set)entry.getValue()).stream().map(AliasMetadata::alias).collect(Collectors.toSet())));
    }

    public Map<String, Set<String>> fieldsInIndices(String[] writeIndexWildcards) {
        List<String> indexWildCards = Arrays.asList(writeIndexWildcards);
        return this.clusterStateApi.fields(indexWildCards);
    }

    public Set<String> closedIndices(Collection<String> indices) {
        return this.catApi.indices(indices, Collections.singleton("close"), "Unable to retrieve list of closed indices for " + String.valueOf(indices));
    }

    public Set<IndexStatistics> indicesStats(Collection<String> indices) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        JsonNode allWithShardLevel = this.statsApi.indexStatsWithShardLevel(indices);
        Iterator fields = allWithShardLevel.fields();
        while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            String index = (String)entry.getKey();
            JsonNode indexStats = (JsonNode)entry.getValue();
            if (!indexStats.isObject()) continue;
            result.add((Object)IndexStatistics.create((String)index, (JsonNode)indexStats));
        }
        return result.build();
    }

    public Optional<IndexStatistics> getIndexStats(String index) {
        JsonNode indexStats = this.statsApi.indexStatsWithShardLevel(index);
        return indexStats.isMissingNode() ? Optional.empty() : Optional.of(IndexStatistics.create((String)index, (JsonNode)indexStats));
    }

    public JsonNode getIndexStats(Collection<String> indices) {
        return this.statsApi.indexStatsWithDocsAndStore(indices);
    }

    public IndexSetStats getIndexSetStats() {
        return this.clusterStatsApi.clusterStats();
    }

    public List<ShardsInfo> getShardsInfo(String indexName) {
        return this.catApi.getShardsInfo(indexName);
    }

    public IndicesBlockStatus getIndicesBlocksStatus(List<String> indices) {
        if (indices == null || indices.isEmpty()) {
            throw new IllegalArgumentException("Expecting list of indices with at least one index present.");
        }
        GetSettingsRequest request = new GetSettingsRequest().indicesOptions(IndicesOptions.fromOptions(false, true, true, true)).names("index.blocks.read", "index.blocks.write", "index.blocks.metadata", "index.blocks.read_only", "index.blocks.read_only_allow_delete");
        boolean maxLengthExceeded = String.join((CharSequence)",", indices).length() > 3000;
        GetSettingsRequest getSettingsRequest = maxLengthExceeded ? request : request.indices(indices.toArray(new String[0]));
        return this.client.execute((c, requestOptions) -> {
            GetSettingsResponse settingsResponse = c.indices().getSettings(getSettingsRequest, (RequestOptions)requestOptions);
            return BlockSettingsParser.parseBlockSettings(settingsResponse, maxLengthExceeded ? Optional.of(indices) : Optional.empty());
        });
    }

    public boolean exists(String index) {
        GetSettingsResponse result = this.settingsFor(index);
        return result.getIndexToSettings().size() == 1 && result.getIndexToSettings().containsKey(index);
    }

    public boolean aliasExists(String alias) {
        GetAliasesRequest request = new GetAliasesRequest(alias);
        return this.client.execute((c, requestOptions) -> c.indices().existsAlias(request, (RequestOptions)requestOptions));
    }

    public Set<String> indices(String indexWildcard, List<String> status, String indexSetId) {
        return this.catApi.indices(indexWildcard, status, "Couldn't get index list for index set <" + indexSetId + ">");
    }

    public Optional<Long> storeSizeInBytes(String index) {
        return this.statsApi.storeSizes(index);
    }

    public void cycleAlias(String aliasName, String targetIndex) {
        IndicesAliasesRequest.AliasActions addAlias = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD).index(targetIndex).alias(aliasName);
        IndicesAliasesRequest indicesAliasesRequest = new IndicesAliasesRequest().addAliasAction(addAlias);
        this.client.execute((c, requestOptions) -> c.indices().updateAliases(indicesAliasesRequest, (RequestOptions)requestOptions), "Couldn't point alias " + aliasName + " to index " + targetIndex);
    }

    public void cycleAlias(String aliasName, String targetIndex, String oldIndex) {
        IndicesAliasesRequest.AliasActions addAlias = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD).index(targetIndex).alias(aliasName);
        IndicesAliasesRequest.AliasActions removeAlias = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.REMOVE).index(oldIndex).alias(aliasName);
        IndicesAliasesRequest indicesAliasesRequest = new IndicesAliasesRequest().addAliasAction(removeAlias).addAliasAction(addAlias);
        this.client.execute((c, requestOptions) -> c.indices().updateAliases(indicesAliasesRequest, (RequestOptions)requestOptions), "Couldn't switch alias " + aliasName + " from index " + oldIndex + " to index " + targetIndex);
    }

    public void removeAliases(Set<String> indices, String alias) {
        IndicesAliasesRequest indicesAliasesRequest = new IndicesAliasesRequest();
        IndicesAliasesRequest.AliasActions aliasAction = IndicesAliasesRequest.AliasActions.remove().alias(alias).indices(indices.toArray(new String[0]));
        indicesAliasesRequest.addAliasAction(aliasAction);
        this.client.execute((c, requestOptions) -> c.indices().updateAliases(indicesAliasesRequest, (RequestOptions)requestOptions), "Couldn't remove alias " + alias + " from indices " + String.valueOf(indices));
    }

    public void optimizeIndex(String index, int maxNumSegments, Duration timeout) {
        ForceMergeRequest request = ((ForceMergeRequest)new ForceMergeRequest(new String[0]).indices(new String[]{index})).maxNumSegments(maxNumSegments).flush(true);
        this.client.execute((c, requestOptions) -> c.indices().forcemerge(request, ElasticsearchClient.withTimeout(requestOptions, timeout)));
    }

    public IndexRangeStats indexRangeStatsOfIndex(String index) {
        FilterAggregationBuilder builder = (FilterAggregationBuilder)((FilterAggregationBuilder)((FilterAggregationBuilder)AggregationBuilders.filter("agg", QueryBuilders.existsQuery("timestamp")).subAggregation((AggregationBuilder)AggregationBuilders.min("ts_min").field("timestamp"))).subAggregation((AggregationBuilder)AggregationBuilders.max("ts_max").field("timestamp"))).subAggregation((AggregationBuilder)AggregationBuilders.terms("streams").size(Integer.MAX_VALUE).field("streams"));
        SearchSourceBuilder query = SearchSourceBuilder.searchSource().aggregation(builder).size(0);
        SearchRequest request = new SearchRequest().source(query).indices(index).searchType(SearchType.DFS_QUERY_THEN_FETCH).indicesOptions(IndicesOptions.lenientExpandOpen());
        SearchResponse result = this.client.execute((c, requestOptions) -> c.search(request, (RequestOptions)requestOptions), "Couldn't build index range of index " + index);
        if (result.getTotalShards() == 0 || result.getAggregations() == null) {
            throw new IndexNotFoundException("Couldn't build index range of index " + index + " because it doesn't exist.");
        }
        Filter f = (Filter)result.getAggregations().get("agg");
        if (f == null) {
            throw new IndexNotFoundException("Couldn't build index range of index " + index + " because it doesn't exist.");
        }
        if (f.getDocCount() == 0L) {
            LOG.debug("No documents with attribute \"timestamp\" found in index <{}>", (Object)index);
            return IndexRangeStats.EMPTY;
        }
        Min minAgg = (Min)f.getAggregations().get("ts_min");
        long minUnixTime = Double.valueOf(minAgg.getValue()).longValue();
        DateTime min = new DateTime(minUnixTime, DateTimeZone.UTC);
        Max maxAgg = (Max)f.getAggregations().get("ts_max");
        long maxUnixTime = Double.valueOf(maxAgg.getValue()).longValue();
        DateTime max = new DateTime(maxUnixTime, DateTimeZone.UTC);
        Terms streams = (Terms)f.getAggregations().get("streams");
        List streamIds = streams.getBuckets().stream().map(MultiBucketsAggregation.Bucket::getKeyAsString).collect(Collectors.toList());
        return IndexRangeStats.create((DateTime)min, (DateTime)max, streamIds);
    }

    public HealthStatus waitForRecovery(String index) {
        return this.waitForRecovery(index, 30);
    }

    public HealthStatus waitForRecovery(String index, int timeout) {
        ClusterHealthRequest clusterHealthRequest = new ClusterHealthRequest(index).timeout(TimeValue.timeValueSeconds(timeout));
        clusterHealthRequest.waitForGreenStatus();
        ClusterHealthResponse result = this.client.execute((c, requestOptions) -> c.cluster().health(clusterHealthRequest, (RequestOptions)requestOptions));
        return HealthStatus.fromString((String)result.getStatus().toString());
    }

    public boolean isOpen(String index) {
        return this.indexHasState(index, State.Open);
    }

    public boolean isClosed(String index) {
        return this.indexHasState(index, State.Closed);
    }

    public void refresh(String ... indices) {
        RefreshRequest refreshRequest = Requests.refreshRequest(indices);
        this.client.execute((c, requestOptions) -> c.indices().refresh(refreshRequest, (RequestOptions)requestOptions));
    }

    private Boolean indexHasState(String index, State open) {
        return this.indexState(index).map(state -> state.equals((Object)open)).orElseThrow(() -> new IndexNotFoundException("Unable to determine state for absent index " + index));
    }

    private Optional<State> indexState(String index) {
        Optional<String> result = this.catApi.indexState(index, "Unable to retrieve index stats for " + index);
        return result.map(State::parse);
    }

    public String getIndexId(String index) {
        GetSettingsRequest request = new GetSettingsRequest().indices(index).indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED);
        GetSettingsResponse response = this.client.execute((c, requestOptions) -> c.indices().getSettings(request, (RequestOptions)requestOptions), "Unable to retrieve settings for index/alias " + index);
        return response.getSetting(index, "index.uuid");
    }

    public Optional<WarmIndexInfo> getWarmIndexInfo(String index) {
        return Optional.empty();
    }

    static enum State {
        Open,
        Closed;


        static State parse(String state) {
            switch (state.toLowerCase(Locale.ENGLISH)) {
                case "open": {
                    return Open;
                }
                case "close": {
                    return Closed;
                }
            }
            throw new IllegalStateException("Unable to parse invalid index state: " + state);
        }
    }
}

