/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import jakarta.inject.Inject;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.RequestOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.indices.IndexTemplatesExistRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.indices.PutIndexTemplateRequest;
import org.graylog.storage.elasticsearch7.ElasticsearchClient;
import org.graylog.storage.elasticsearch7.IndexTemplateAdapter;
import org.graylog2.indexer.indices.Template;

public class LegacyIndexTemplateAdapter
implements IndexTemplateAdapter {
    private final ElasticsearchClient client;

    @Inject
    public LegacyIndexTemplateAdapter(ElasticsearchClient client) {
        this.client = client;
    }

    @Override
    public boolean ensureIndexTemplate(String templateName, Template template) {
        Map<String, Object> templateSource = Map.of("index_patterns", template.indexPatterns(), "mappings", template.mappings(), "settings", template.settings(), "order", template.order());
        PutIndexTemplateRequest request = new PutIndexTemplateRequest(templateName).source(templateSource);
        AcknowledgedResponse result = this.client.execute((c, requestOptions) -> c.indices().putTemplate(request, (RequestOptions)requestOptions), "Unable to create index template " + templateName);
        return result.isAcknowledged();
    }

    @Override
    public boolean indexTemplateExists(String templateName) {
        return this.client.execute((c, requestOptions) -> c.indices().existsTemplate(new IndexTemplatesExistRequest(templateName), (RequestOptions)requestOptions), "Unable to verify index template existence " + templateName);
    }

    @Override
    public boolean deleteIndexTemplate(String templateName) {
        DeleteIndexTemplateRequest request = new DeleteIndexTemplateRequest(templateName);
        AcknowledgedResponse result = this.client.execute((c, requestOptions) -> c.indices().deleteTemplate(request, (RequestOptions)requestOptions), "Unable to delete index template " + templateName);
        return result.isAcknowledged();
    }
}

