/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.zafarkhaja.semver.Version;
import jakarta.inject.Inject;
import java.util.Optional;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Request;
import org.graylog.storage.elasticsearch7.ElasticsearchClient;
import org.graylog.storage.elasticsearch7.PlainJsonApi;
import org.graylog2.indexer.cluster.NodeAdapter;
import org.graylog2.shared.utilities.StringUtils;
import org.graylog2.storage.SearchVersion;

public class NodeAdapterES7
implements NodeAdapter {
    private final PlainJsonApi jsonApi;

    @Inject
    public NodeAdapterES7(ElasticsearchClient client, ObjectMapper objectMapper) {
        this.jsonApi = new PlainJsonApi(objectMapper, client);
    }

    NodeAdapterES7(PlainJsonApi jsonApi) {
        this.jsonApi = jsonApi;
    }

    public Optional<SearchVersion> version() {
        Request request = new Request("GET", "/?filter_path=version.number,version.distribution");
        Optional<JsonNode> resp = Optional.of(this.jsonApi.perform(request, "Unable to retrieve cluster information"));
        Optional<String> version = resp.map(r -> r.path("version")).map(r -> r.path("number")).map(JsonNode::textValue);
        SearchVersion.Distribution distribution = resp.map(r -> r.path("version")).map(r -> r.path("distribution")).map(JsonNode::textValue).map(StringUtils::toUpperCase).map(SearchVersion.Distribution::valueOf).orElse(SearchVersion.Distribution.ELASTICSEARCH);
        return version.map(arg_0 -> ((NodeAdapterES7)this).parseVersion(arg_0)).map(v -> SearchVersion.create((SearchVersion.Distribution)distribution, (Version)v));
    }
}

