/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Node;
import org.graylog.storage.elasticsearch7.NodesSniffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeListSniffer
implements NodesSniffer {
    private static final Logger LOG = LoggerFactory.getLogger(NodeListSniffer.class);
    private static final Set<String> savedNodes = ConcurrentHashMap.newKeySet();

    static NodeListSniffer create() {
        return new NodeListSniffer();
    }

    @Override
    public List<Node> sniff(List<Node> nodes) {
        Set currentNodes = nodes.stream().map(n -> n.getHost().toURI()).collect(Collectors.toSet());
        Sets.SetView nodesAdded = Sets.difference(currentNodes, savedNodes);
        Sets.SetView nodesDropped = Sets.difference(savedNodes, currentNodes);
        if (!nodesAdded.isEmpty()) {
            LOG.info("Added node(s): {}", (Object)nodesAdded);
        }
        if (!nodesDropped.isEmpty()) {
            LOG.info("Dropped node(s): {}", (Object)nodesDropped);
        }
        if (!nodesAdded.isEmpty() || !nodesDropped.isEmpty()) {
            LOG.info("Current node list: {}", currentNodes);
        }
        savedNodes.clear();
        savedNodes.addAll(currentNodes);
        return nodes;
    }
}

