/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.List;
import javax.annotation.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.SearchHit;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.storage.elasticsearch7.ChunkedQueryResultES7;
import org.graylog.storage.elasticsearch7.ElasticsearchClient;
import org.graylog2.indexer.results.ResultMessageFactory;

public class PaginationResultES7
extends ChunkedQueryResultES7 {
    private SearchRequest initialSearchRequest;

    @AssistedInject
    public PaginationResultES7(ResultMessageFactory resultMessageFactory, ElasticsearchClient client, SearchRequest initialSearchRequest, @Assisted SearchResponse initialResult, @Assisted(value="query") String query, @Assisted List<String> fields, @Assisted int limit) {
        super(resultMessageFactory, client, initialResult, query, fields, limit);
        this.initialSearchRequest = initialSearchRequest;
    }

    @Nullable
    protected SearchResponse nextSearchResult() {
        SearchSourceBuilder initialQuery = this.initialSearchRequest.source();
        SearchHit[] hits = ((SearchResponse)this.lastSearchResponse).getHits().getHits();
        if (hits == null || hits.length == 0) {
            return null;
        }
        initialQuery.searchAfter(hits[hits.length - 1].getSortValues());
        this.initialSearchRequest.source(initialQuery);
        return ((ElasticsearchClient)this.client).search(this.initialSearchRequest, "Unable to retrieve next chunk from search: ");
    }

    protected String getChunkingMethodName() {
        return "search-after pagination";
    }

    public void cancel() {
    }
}

