/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import com.google.auto.value.AutoValue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graylog.storage.elasticsearch7.AutoValue_ParsedElasticsearchException;

@AutoValue
public abstract class ParsedElasticsearchException {
    private static final Pattern exceptionPattern = Pattern.compile("(ElasticsearchException\\[)?Elasticsearch exception \\[type=(?<type>[\\w_]+), (?:reason=(?<reason>.+?)(\\]+;|\\]$))");

    public abstract String type();

    public abstract String reason();

    public static ParsedElasticsearchException create(String type, String reason) {
        return new AutoValue_ParsedElasticsearchException(type, reason);
    }

    public static ParsedElasticsearchException from(String s) {
        Matcher matcher = exceptionPattern.matcher(s);
        if (matcher.find()) {
            String type = matcher.group("type");
            String reason = matcher.group("reason");
            return ParsedElasticsearchException.create(type, reason);
        }
        throw new IllegalArgumentException("Unable to parse Elasticsearch exception: " + s);
    }
}

