/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Request;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.RequestOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Response;
import org.graylog.storage.elasticsearch7.ElasticsearchClient;

public class PlainJsonApi {
    private final ObjectMapper objectMapper;
    private final ElasticsearchClient client;

    @Inject
    public PlainJsonApi(ObjectMapper objectMapper, ElasticsearchClient client) {
        this.objectMapper = objectMapper;
        this.client = client;
    }

    public JsonNode perform(Request request, String errorMessage) {
        return this.client.execute((c, requestOptions) -> {
            request.setOptions((RequestOptions)requestOptions);
            Response response = c.getLowLevelClient().performRequest(request);
            return this.objectMapper.readTree(response.getEntity().getContent());
        }, errorMessage);
    }
}

