/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog.plugins.views.search.elasticsearch.IndexLookup;
import org.graylog.plugins.views.search.engine.QuerySuggestionsService;
import org.graylog.plugins.views.search.engine.suggestions.SuggestionEntry;
import org.graylog.plugins.views.search.engine.suggestions.SuggestionError;
import org.graylog.plugins.views.search.engine.suggestions.SuggestionFieldType;
import org.graylog.plugins.views.search.engine.suggestions.SuggestionRequest;
import org.graylog.plugins.views.search.engine.suggestions.SuggestionResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.IndicesOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.BoolQueryBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.ScriptQueryBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.Script;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.ScriptType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms.ParsedTerms;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.suggest.SuggestBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.suggest.SuggestBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.suggest.term.TermSuggestion;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.suggest.term.TermSuggestionBuilder;
import org.graylog.storage.elasticsearch7.ElasticsearchClient;
import org.graylog.storage.elasticsearch7.ParsedElasticsearchException;
import org.graylog.storage.elasticsearch7.TimeRangeQueryFactory;
import org.graylog.storage.errors.ResponseError;

public class QuerySuggestionsES7
implements QuerySuggestionsService {
    private final ElasticsearchClient client;
    private final IndexLookup indexLookup;

    @Inject
    public QuerySuggestionsES7(ElasticsearchClient client, IndexLookup indexLookup) {
        this.client = client;
        this.indexLookup = indexLookup;
    }

    public SuggestionResponse suggest(SuggestionRequest req) {
        Set affectedIndices = this.indexLookup.indexNamesForStreamsInTimeRange((Collection)req.streams(), req.timerange());
        TermSuggestionBuilder suggestionBuilder = (TermSuggestionBuilder)((TermSuggestionBuilder)SuggestBuilders.termSuggestion(req.field()).text(req.input())).size(req.size());
        BoolQueryBuilder query = QueryBuilders.boolQuery().filter(QueryBuilders.termsQuery("streams", req.streams())).filter(TimeRangeQueryFactory.create(req.timerange())).filter(QueryBuilders.existsQuery(req.field())).filter(this.getPrefixQuery(req));
        SearchSourceBuilder search = new SearchSourceBuilder().query(query).size(0).aggregation(((TermsAggregationBuilder)AggregationBuilders.terms("fieldvalues").field(req.field())).size(req.size())).suggest(new SuggestBuilder().addSuggestion("corrections", suggestionBuilder));
        try {
            SearchResponse result = this.client.search(new SearchRequest(affectedIndices.toArray(new String[0])).source(search).indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN), "Failed to execute aggregation");
            ParsedTerms fieldValues = (ParsedTerms)result.getAggregations().get("fieldvalues");
            List entries = fieldValues.getBuckets().stream().map(b -> new SuggestionEntry(b.getKeyAsString(), b.getDocCount())).collect(Collectors.toList());
            if (!entries.isEmpty()) {
                return SuggestionResponse.forSuggestions((String)req.field(), (String)req.input(), entries, (Long)fieldValues.getSumOfOtherDocCounts());
            }
            TermSuggestion suggestion = (TermSuggestion)result.getSuggest().getSuggestion("corrections");
            List corrections = suggestion.getEntries().stream().flatMap(e -> e.getOptions().stream()).map(o -> new SuggestionEntry(o.getText().string(), (long)o.getFreq())).collect(Collectors.toList());
            return SuggestionResponse.forSuggestions((String)req.field(), (String)req.input(), corrections, null);
        }
        catch (ElasticsearchException exception) {
            SuggestionError err = this.tryResponseException(exception).orElseGet(() -> this.parseException(exception));
            return SuggestionResponse.forError((String)req.field(), (String)req.input(), (SuggestionError)err);
        }
    }

    private QueryBuilder getPrefixQuery(SuggestionRequest req) {
        return switch (req.fieldType()) {
            case SuggestionFieldType.TEXTUAL -> QueryBuilders.prefixQuery(req.field(), req.input());
            default -> QuerySuggestionsES7.getScriptedPrefixQuery(req);
        };
    }

    private static ScriptQueryBuilder getScriptedPrefixQuery(SuggestionRequest req) {
        Script script = new Script(ScriptType.INLINE, "painless", "String val = doc[params.field].value.toString(); return val.startsWith(params.input);", (Map<String, Object>)ImmutableMap.of((Object)"field", (Object)req.field(), (Object)"input", (Object)req.input()));
        return QueryBuilders.scriptQuery(script);
    }

    private Optional<SuggestionError> tryResponseException(ElasticsearchException exception) {
        return this.client.parseResponseException(exception).map(ResponseError::error).flatMap(e -> e.rootCause().stream().findFirst()).map(e -> SuggestionError.create((String)e.type(), (String)e.reason()));
    }

    private SuggestionError parseException(ElasticsearchException exception) {
        Throwable cause = this.getCause(exception);
        try {
            ParsedElasticsearchException parsed = ParsedElasticsearchException.from(cause.toString());
            return SuggestionError.create((String)parsed.type(), (String)parsed.reason());
        }
        catch (IllegalArgumentException iae) {
            return SuggestionError.create((String)"Aggregation error", (String)cause.getMessage());
        }
    }

    private Throwable getCause(Throwable exception) {
        if (exception.getCause() != null) {
            return this.getCause(exception.getCause());
        }
        return exception;
    }
}

