/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import com.github.joschi.jadconfig.util.Duration;
import com.google.common.base.Suppliers;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.graylog.shaded.elasticsearch7.org.apache.http.HttpHost;
import org.graylog.shaded.elasticsearch7.org.apache.http.client.CredentialsProvider;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.RestClient;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.RestClientBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.RestHighLevelClient;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.sniff.ElasticsearchNodesSniffer;
import org.graylog.storage.elasticsearch7.ElasticsearchFilterDeprecationWarningsInterceptor;
import org.graylog.storage.elasticsearch7.FilteredElasticsearchNodesSniffer;
import org.graylog.storage.elasticsearch7.NodeListSniffer;
import org.graylog.storage.elasticsearch7.SnifferWrapper;
import org.graylog2.configuration.IndexerHosts;
import org.graylog2.system.shutdown.GracefulShutdownService;

@Singleton
public class RestHighLevelClientProvider
implements Provider<RestHighLevelClient> {
    private final Supplier<RestHighLevelClient> clientSupplier = Suppliers.memoize(() -> {
        RestHighLevelClient client = this.buildClient(hosts, connectTimeout, socketTimeout, maxTotalConnections, maxTotalConnectionsPerRoute, useExpectContinue, muteElasticsearchDeprecationWarnings, credentialsProvider);
        SnifferWrapper sniffer = SnifferWrapper.create(client.getLowLevelClient(), TimeUnit.SECONDS.toMillis(5L), discoveryFrequency, this.mapDefaultScheme(defaultSchemeForDiscoveredNodes));
        if (discoveryEnabled) {
            sniffer.add(FilteredElasticsearchNodesSniffer.create(discoveryFilter));
        }
        if (nodeActivity) {
            sniffer.add(NodeListSniffer.create());
        }
        sniffer.build().ifPresent(s -> shutdownService.register(s::close));
        return client;
    });

    @Inject
    public RestHighLevelClientProvider(GracefulShutdownService shutdownService, @IndexerHosts List<URI> hosts, @Named(value="elasticsearch_connect_timeout") Duration connectTimeout, @Named(value="elasticsearch_socket_timeout") Duration socketTimeout, @Named(value="elasticsearch_idle_timeout") Duration elasticsearchIdleTimeout, @Named(value="elasticsearch_max_total_connections") int maxTotalConnections, @Named(value="elasticsearch_max_total_connections_per_route") int maxTotalConnectionsPerRoute, @Named(value="elasticsearch_max_retries") int elasticsearchMaxRetries, @Named(value="elasticsearch_discovery_enabled") boolean discoveryEnabled, @Named(value="elasticsearch_node_activity_logger_enabled") boolean nodeActivity, @Named(value="elasticsearch_discovery_filter") @Nullable String discoveryFilter, @Named(value="elasticsearch_discovery_frequency") Duration discoveryFrequency, @Named(value="elasticsearch_discovery_default_scheme") String defaultSchemeForDiscoveredNodes, @Named(value="elasticsearch_use_expect_continue") boolean useExpectContinue, @Named(value="elasticsearch_mute_deprecation_warnings") boolean muteElasticsearchDeprecationWarnings, CredentialsProvider credentialsProvider) {
    }

    private ElasticsearchNodesSniffer.Scheme mapDefaultScheme(String defaultSchemeForDiscoveredNodes) {
        switch (defaultSchemeForDiscoveredNodes.toUpperCase(Locale.ENGLISH)) {
            case "HTTP": {
                return ElasticsearchNodesSniffer.Scheme.HTTP;
            }
            case "HTTPS": {
                return ElasticsearchNodesSniffer.Scheme.HTTPS;
            }
        }
        throw new IllegalArgumentException("Invalid default scheme for discovered ES nodes: " + defaultSchemeForDiscoveredNodes);
    }

    public RestHighLevelClient get() {
        return this.clientSupplier.get();
    }

    private RestHighLevelClient buildClient(List<URI> hosts, Duration connectTimeout, Duration socketTimeout, int maxTotalConnections, int maxTotalConnectionsPerRoute, boolean useExpectContinue, boolean muteElasticsearchDeprecationWarnings, CredentialsProvider credentialsProvider) {
        HttpHost[] esHosts = (HttpHost[])hosts.stream().map(uri -> new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme())).toArray(HttpHost[]::new);
        RestClientBuilder restClientBuilder = RestClient.builder(esHosts).setRequestConfigCallback(requestConfig -> requestConfig.setConnectTimeout(Math.toIntExact(connectTimeout.toMilliseconds())).setSocketTimeout(Math.toIntExact(socketTimeout.toMilliseconds())).setExpectContinueEnabled(useExpectContinue).setAuthenticationEnabled(true)).setHttpClientConfigCallback(httpClientConfig -> {
            httpClientConfig.setMaxConnTotal(maxTotalConnections).setMaxConnPerRoute(maxTotalConnectionsPerRoute).setDefaultCredentialsProvider(credentialsProvider);
            if (muteElasticsearchDeprecationWarnings) {
                httpClientConfig.addInterceptorFirst(new ElasticsearchFilterDeprecationWarningsInterceptor());
            }
            return httpClientConfig;
        });
        return new RestHighLevelClient(restClientBuilder);
    }
}

