/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.ClearScrollRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchScrollRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.RequestOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.unit.TimeValue;
import org.graylog.storage.elasticsearch7.ChunkedQueryResultES7;
import org.graylog.storage.elasticsearch7.ElasticsearchClient;
import org.graylog2.indexer.results.ResultMessageFactory;

public class ScrollResultES7
extends ChunkedQueryResultES7 {
    private static final TimeValue DEFAULT_SCROLL = TimeValue.timeValueMinutes(1L);
    private final String scroll;

    @AssistedInject
    public ScrollResultES7(ResultMessageFactory resultMessagseFactory, ElasticsearchClient client, @Assisted SearchResponse initialResult, @Assisted(value="query") String query, @Assisted(value="scroll") String scroll, @Assisted List<String> fields, @Assisted int limit) {
        super(resultMessagseFactory, client, initialResult, query, fields, limit);
        this.scroll = scroll;
    }

    @Nullable
    protected SearchResponse nextSearchResult() throws IOException {
        if (((SearchResponse)this.lastSearchResponse).getScrollId() == null) {
            return null;
        }
        SearchScrollRequest scrollRequest = new SearchScrollRequest(((SearchResponse)this.lastSearchResponse).getScrollId());
        scrollRequest.scroll(TimeValue.parseTimeValue(this.scroll, DEFAULT_SCROLL, "scroll time"));
        return ((ElasticsearchClient)this.client).executeWithIOException((c, requestOptions) -> c.scroll(scrollRequest, (RequestOptions)requestOptions), "Unable to retrieve next chunk from search: ");
    }

    public void cancel() throws IOException {
        if (((SearchResponse)this.lastSearchResponse).getScrollId() == null) {
            return;
        }
        ClearScrollRequest request = new ClearScrollRequest();
        request.addScrollId(((SearchResponse)this.lastSearchResponse).getScrollId());
        ((ElasticsearchClient)this.client).executeWithIOException((c, requestOptions) -> c.clearScroll(request, (RequestOptions)requestOptions), "Unable to cancel scrolling search request");
    }

    protected String getChunkingMethodName() {
        return "scroll";
    }

    public static interface Factory {
        public ScrollResultES7 create(SearchResponse var1, @Assisted(value="query") String var2, @Assisted(value="scroll") String var3, List<String> var4, int var5);
    }
}

