/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import com.google.auto.value.AutoValue;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import org.graylog.plugins.views.search.searchfilters.model.UsedSearchFilter;
import org.graylog.storage.elasticsearch7.AutoValue_SearchCommand;
import org.graylog2.indexer.searches.ChunkCommand;
import org.graylog2.indexer.searches.SearchesConfig;
import org.graylog2.indexer.searches.Sorting;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

@AutoValue
abstract class SearchCommand {
    SearchCommand() {
    }

    public abstract String query();

    public abstract Optional<Set<String>> streams();

    public abstract Optional<Sorting> sorting();

    public abstract Optional<String> filter();

    public abstract List<UsedSearchFilter> filters();

    public abstract Optional<TimeRange> range();

    public abstract OptionalInt limit();

    public abstract OptionalInt offset();

    public abstract OptionalLong batchSize();

    public abstract boolean highlight();

    private static SearchCommand create(String query, Optional<Set<String>> streams, Optional<Sorting> sorting, Optional<String> filter, List<UsedSearchFilter> filters, Optional<TimeRange> range, OptionalInt limit, OptionalInt offset, OptionalLong batchSize, boolean highlight) {
        return new AutoValue_SearchCommand(query, streams, sorting, filter, filters, range, limit, offset, batchSize, highlight);
    }

    static SearchCommand from(SearchesConfig searchesConfig) {
        return SearchCommand.create(searchesConfig.query(), Optional.empty(), Optional.ofNullable(searchesConfig.sorting()), Optional.ofNullable(searchesConfig.filter()), Collections.emptyList(), Optional.of(searchesConfig.range()), OptionalInt.of(searchesConfig.limit()), OptionalInt.of(searchesConfig.offset()), OptionalLong.empty(), true);
    }

    static SearchCommand from(ChunkCommand chunkCommand) {
        return SearchCommand.create(chunkCommand.query(), chunkCommand.streams(), chunkCommand.sorting(), chunkCommand.filter(), chunkCommand.filters(), chunkCommand.range(), chunkCommand.limit(), chunkCommand.offset(), chunkCommand.batchSize(), chunkCommand.highlight());
    }
}

