/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import com.github.joschi.jadconfig.util.Duration;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Node;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.RestClient;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.sniff.ElasticsearchNodesSniffer;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.sniff.Sniffer;
import org.graylog.storage.elasticsearch7.NodesSniffer;

public class SnifferWrapper
implements org.graylog.shaded.elasticsearch7.org.elasticsearch.client.sniff.NodesSniffer {
    private final List<NodesSniffer> sniffers = new CopyOnWriteArrayList<NodesSniffer>();
    private final RestClient restClient;
    private final long sniffRequestTimeoutMillis;
    private final Duration discoveryFrequency;
    private final ElasticsearchNodesSniffer.Scheme scheme;
    private org.graylog.shaded.elasticsearch7.org.elasticsearch.client.sniff.NodesSniffer nodesSniffer;

    private SnifferWrapper(RestClient restClient, long sniffRequestTimeoutMillis, Duration discoveryFrequency, ElasticsearchNodesSniffer.Scheme scheme) {
        this.restClient = restClient;
        this.sniffRequestTimeoutMillis = sniffRequestTimeoutMillis;
        this.discoveryFrequency = discoveryFrequency;
        this.scheme = scheme;
    }

    @Override
    public List<Node> sniff() throws IOException {
        List<Node> nodes = this.nodesSniffer.sniff();
        for (NodesSniffer sniffer : this.sniffers) {
            nodes = sniffer.sniff(nodes);
        }
        return nodes;
    }

    public static SnifferWrapper create(RestClient restClient, long sniffRequestTimeoutMillis, Duration discoveryFrequency, ElasticsearchNodesSniffer.Scheme scheme) {
        return new SnifferWrapper(restClient, sniffRequestTimeoutMillis, discoveryFrequency, scheme);
    }

    public Optional<Sniffer> build() {
        if (this.sniffers.isEmpty()) {
            return Optional.empty();
        }
        this.nodesSniffer = new ElasticsearchNodesSniffer(this.restClient, this.sniffRequestTimeoutMillis, this.scheme);
        return Optional.of(Sniffer.builder(this.restClient).setSniffIntervalMillis(Math.toIntExact(this.discoveryFrequency.toMilliseconds())).setNodesSniffer(this).build());
    }

    public void add(NodesSniffer sniffer) {
        this.sniffers.add(sniffer);
    }
}

