/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.multibindings.MapBinder;
import org.graylog.plugins.views.ViewsModule;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.export.ExportBackend;
import org.graylog.plugins.views.search.searchtypes.pivot.BucketSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSpec;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregation;
import org.graylog.storage.elasticsearch7.views.ESGeneratedQueryContext;
import org.graylog.storage.elasticsearch7.views.ElasticsearchBackend;
import org.graylog.storage.elasticsearch7.views.export.ElasticsearchExportBackend;
import org.graylog.storage.elasticsearch7.views.export.RequestStrategy;
import org.graylog.storage.elasticsearch7.views.export.SearchAfter;
import org.graylog.storage.elasticsearch7.views.searchtypes.ESEventList;
import org.graylog.storage.elasticsearch7.views.searchtypes.ESMessageList;
import org.graylog.storage.elasticsearch7.views.searchtypes.ESSearchTypeHandler;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.ESPivot;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.ESPivotBucketSpecHandler;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.ESPivotSeriesSpecHandler;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.buckets.ESDateRangeHandler;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.buckets.ESTimeHandler;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.buckets.ESValuesHandler;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.series.ESAverageHandler;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.series.ESCardinalityHandler;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.series.ESCountHandler;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.series.ESLatestHandler;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.series.ESMaxHandler;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.series.ESMinHandler;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.series.ESPercentageHandler;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.series.ESPercentilesHandler;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.series.ESStdDevHandler;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.series.ESSumHandler;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.series.ESSumOfSquaresHandler;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.series.ESVarianceHandler;
import org.graylog2.storage.SearchVersion;

public class ViewsESBackendModule
extends ViewsModule {
    private final SearchVersion supportedSearchVersion;

    public ViewsESBackendModule(SearchVersion supportedSearchVersion) {
        this.supportedSearchVersion = supportedSearchVersion;
    }

    protected void configure() {
        this.install(new FactoryModuleBuilder().build(ESGeneratedQueryContext.Factory.class));
        this.registerVersionedQueryBackend(this.supportedSearchVersion, ElasticsearchBackend.class);
        this.registerESSearchTypeHandler("messages", ESMessageList.class);
        this.registerESSearchTypeHandler("events", ESEventList.class);
        this.registerESSearchTypeHandler("pivot", ESPivot.class).in(Scopes.SINGLETON);
        this.registerPivotSeriesHandler("avg", ESAverageHandler.class);
        this.registerPivotSeriesHandler("card", ESCardinalityHandler.class);
        this.registerPivotSeriesHandler("count", ESCountHandler.class);
        this.registerPivotSeriesHandler("max", ESMaxHandler.class);
        this.registerPivotSeriesHandler("min", ESMinHandler.class);
        this.registerPivotSeriesHandler("stddev", ESStdDevHandler.class);
        this.registerPivotSeriesHandler("sum", ESSumHandler.class);
        this.registerPivotSeriesHandler("sumofsquares", ESSumOfSquaresHandler.class);
        this.registerPivotSeriesHandler("variance", ESVarianceHandler.class);
        this.registerPivotSeriesHandler("percentage", ESPercentageHandler.class);
        this.registerPivotSeriesHandler("percentile", ESPercentilesHandler.class);
        this.registerPivotSeriesHandler("latest", ESLatestHandler.class);
        this.registerPivotBucketHandler("values", ESValuesHandler.class);
        this.registerPivotBucketHandler("time", ESTimeHandler.class);
        this.registerPivotBucketHandler("date_range", ESDateRangeHandler.class);
        this.bindExportBackend().to(ElasticsearchExportBackend.class);
        this.bindRequestStrategy().to(SearchAfter.class);
    }

    private LinkedBindingBuilder<RequestStrategy> bindRequestStrategy() {
        return this.bind(RequestStrategy.class);
    }

    private LinkedBindingBuilder<ExportBackend> bindExportBackend() {
        return this.bindExportBackend(this.supportedSearchVersion);
    }

    private MapBinder<String, ESPivotBucketSpecHandler<? extends BucketSpec>> pivotBucketHandlerBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)new TypeLiteral<ESPivotBucketSpecHandler<? extends BucketSpec>>(this){});
    }

    private void registerPivotBucketHandler(String name, Class<? extends ESPivotBucketSpecHandler<? extends BucketSpec>> implementation) {
        this.pivotBucketHandlerBinder().addBinding((Object)name).to(implementation);
    }

    protected MapBinder<String, ESPivotSeriesSpecHandler<? extends SeriesSpec, ? extends Aggregation>> pivotSeriesHandlerBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)new TypeLiteral<ESPivotSeriesSpecHandler<? extends SeriesSpec, ? extends Aggregation>>(this){});
    }

    private void registerPivotSeriesHandler(String name, Class<? extends ESPivotSeriesSpecHandler<? extends SeriesSpec, ? extends Aggregation>> implementation) {
        this.pivotSeriesHandlerBinder().addBinding((Object)name).to(implementation);
    }

    private MapBinder<String, ESSearchTypeHandler<? extends SearchType>> esSearchTypeHandlerBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)new TypeLiteral<ESSearchTypeHandler<? extends SearchType>>(this){});
    }

    private ScopedBindingBuilder registerESSearchTypeHandler(String name, Class<? extends ESSearchTypeHandler<? extends SearchType>> implementation) {
        return this.esSearchTypeHandlerBinder().addBinding((Object)name).to(implementation);
    }
}

