/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7.blocks;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.collect.ImmutableOpenMap;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.Settings;
import org.graylog2.indexer.indices.blocks.IndicesBlockStatus;

public class BlockSettingsParser {
    static final String BLOCK_SETTINGS_PREFIX = "index.blocks.";

    public static IndicesBlockStatus parseBlockSettings(GetSettingsResponse settingsResponse) {
        return BlockSettingsParser.parseBlockSettings(settingsResponse, Optional.empty());
    }

    public static IndicesBlockStatus parseBlockSettings(GetSettingsResponse settingsResponse, Optional<List<String>> indices) {
        IndicesBlockStatus result = new IndicesBlockStatus();
        ImmutableOpenMap<String, Settings> indexToSettingsMap = settingsResponse.getIndexToSettings();
        String[] indicesInResponse = indexToSettingsMap.keys().toArray(String.class);
        indices.orElse(Arrays.stream(indicesInResponse).toList()).forEach(index -> {
            Set<String> blockSettingsNames;
            Set blockSettingsSetToTrue;
            Settings blockSettings;
            Settings settings = (Settings)indexToSettingsMap.get((String)index);
            if (settings != null && !(blockSettings = settings.getByPrefix(BLOCK_SETTINGS_PREFIX)).isEmpty() && !(blockSettingsSetToTrue = (blockSettingsNames = blockSettings.names()).stream().filter(s -> blockSettings.getAsBoolean((String)s, false)).map(s -> BLOCK_SETTINGS_PREFIX + s).collect(Collectors.toSet())).isEmpty()) {
                result.addIndexBlocks(index, blockSettingsSetToTrue);
            }
        });
        return result;
    }
}

