/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7.cluster;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Streams;
import jakarta.inject.Inject;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Request;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.RequestOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Response;
import org.graylog.storage.elasticsearch7.ElasticsearchClient;

public class ClusterStateApi {
    private final ObjectMapper objectMapper;
    private final ElasticsearchClient client;

    @Inject
    public ClusterStateApi(ObjectMapper objectMapper, ElasticsearchClient client) {
        this.objectMapper = objectMapper;
        this.client = client;
    }

    public Map<String, Set<String>> fields(Collection<String> indices) {
        Request request = this.request(indices);
        JsonNode jsonResponse = this.client.execute((c, requestOptions) -> {
            request.setOptions((RequestOptions)requestOptions);
            Response response = c.getLowLevelClient().performRequest(request);
            return this.objectMapper.readTree(response.getEntity().getContent());
        }, "Unable to retrieve fields from indices: " + String.join((CharSequence)",", indices));
        return Streams.stream((Iterator)jsonResponse.path("metadata").path("indices").fields()).flatMap(index -> this.allFieldsFromIndex((String)index.getKey(), (JsonNode)index.getValue())).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toSet())));
    }

    private Stream<Map.Entry<String, String>> allFieldsFromIndex(String indexName, JsonNode indexMapping) {
        return Streams.stream((Iterator)indexMapping.path("mappings").fields()).flatMap(documentType -> this.allFieldsFromDocumentType(indexName, (JsonNode)documentType.getValue()));
    }

    private Stream<? extends Map.Entry<String, String>> allFieldsFromDocumentType(String indexName, JsonNode documentType) {
        return Streams.stream((Iterator)documentType.path("properties").fields()).map(field -> new AbstractMap.SimpleEntry<String, String>(indexName, (String)field.getKey()));
    }

    private Request request(Collection<String> indices) {
        StringBuilder apiEndpoint = new StringBuilder("/_cluster/state/metadata");
        if (!indices.isEmpty()) {
            String joinedIndices = String.join((CharSequence)",", indices);
            apiEndpoint.append("/");
            apiEndpoint.append(joinedIndices);
        }
        return new Request("GET", apiEndpoint.toString());
    }
}

