/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7.fieldtypes.streams;

import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregations;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregationBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.filter.ParsedFilters;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.storage.elasticsearch7.ElasticsearchClient;
import org.graylog2.indexer.fieldtypes.streamfiltered.esadapters.StreamsForFieldRetriever;

public class StreamsForFieldRetrieverES7
implements StreamsForFieldRetriever {
    private static final String AGG_NAME = "fields";
    private static final int SEARCH_MAX_BUCKETS_ES = 10000;
    private final ElasticsearchClient client;

    @Inject
    public StreamsForFieldRetrieverES7(ElasticsearchClient client) {
        this.client = client;
    }

    public Map<String, Set<String>> getStreams(List<String> fieldNames, String indexName) {
        SearchResponse response = this.client.search(this.createSearchRequest(fieldNames, indexName), "Unable to retrieve fields types aggregations");
        ParsedFilters aggregation = (ParsedFilters)response.getAggregations().get(AGG_NAME);
        return fieldNames.stream().map(fieldName -> new FieldStreams((String)fieldName, this.retrieveStreamsFromAggregationInResponse(aggregation.getBucketByKey((String)fieldName)))).collect(Collectors.toMap(FieldStreams::fieldName, FieldStreams::streams));
    }

    public Set<String> getStreams(String fieldName, String indexName) {
        SearchRequest searchRequest = this.createSearchRequest(List.of(fieldName), indexName);
        SearchResponse searchResult = this.client.search(searchRequest, "Unable to retrieve fields types aggregations");
        ParsedFilters aggregation = (ParsedFilters)searchResult.getAggregations().get(AGG_NAME);
        ParsedFilters.ParsedBucket bucket = aggregation.getBucketByKey(fieldName);
        return this.retrieveStreamsFromAggregationInResponse(bucket);
    }

    private Set<String> retrieveStreamsFromAggregationInResponse(ParsedFilters.ParsedBucket searchResult) {
        List<? extends MultiBucketsAggregation.Bucket> buckets;
        Object streamsAggregation;
        Aggregations aggregations = searchResult.getAggregations();
        if (aggregations != null && (streamsAggregation = aggregations.get("streams")) instanceof MultiBucketsAggregation && (buckets = ((MultiBucketsAggregation)streamsAggregation).getBuckets()) != null) {
            return buckets.stream().map(MultiBucketsAggregation.Bucket::getKeyAsString).collect(Collectors.toSet());
        }
        return Set.of();
    }

    private SearchRequest createSearchRequest(List<String> fieldNames, String indexName) {
        SearchSourceBuilder searchSourceBuilder = this.createSearchSourceBuilder(fieldNames);
        return new SearchRequest(indexName).source(searchSourceBuilder);
    }

    private SearchSourceBuilder createSearchSourceBuilder(List<String> fieldNames) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().trackTotalHits(false).size(0);
        List<FiltersAggregator.KeyedFilter> filters = fieldNames.stream().map(fieldName -> new FiltersAggregator.KeyedFilter((String)fieldName, QueryBuilders.existsQuery(fieldName))).toList();
        FiltersAggregationBuilder filtersAggregation = (FiltersAggregationBuilder)AggregationBuilders.filters(AGG_NAME, (FiltersAggregator.KeyedFilter[])filters.toArray(FiltersAggregator.KeyedFilter[]::new)).otherBucket(false).subAggregation(((TermsAggregationBuilder)AggregationBuilders.terms("streams").field("streams")).size(10000));
        searchSourceBuilder.aggregation(filtersAggregation);
        return searchSourceBuilder;
    }

    private record FieldStreams(String fieldName, Set<String> streams) {
    }
}

