/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7.stats;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Request;
import org.graylog.storage.elasticsearch7.PlainJsonApi;
import org.graylog2.rest.resources.system.indexer.responses.IndexSetStats;

public class ClusterStatsApi {
    private final ObjectMapper objectMapper;
    private final PlainJsonApi jsonApi;

    @Inject
    public ClusterStatsApi(ObjectMapper objectMapper, PlainJsonApi jsonApi) {
        this.objectMapper = objectMapper;
        this.jsonApi = jsonApi;
    }

    public IndexSetStats clusterStats() {
        Request request = new Request("GET", "/_cluster/stats");
        request.addParameter("filter_path", "indices.count,indices.docs.count,indices.store.size_in_bytes");
        JsonNode stats = this.jsonApi.perform(request, "Couldn't read Elasticsearch cluster stats");
        long indicesCount = stats.path("indices").path("count").asLong();
        long docsCount = stats.path("indices").path("docs").path("count").asLong();
        long sizeBytes = stats.path("indices").path("store").path("size_in_bytes").asLong();
        return IndexSetStats.create((long)indicesCount, (long)docsCount, (long)sizeBytes);
    }
}

