/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7.views.export;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog.plugins.views.search.elasticsearch.IndexLookup;
import org.graylog.plugins.views.search.export.ExportBackend;
import org.graylog.plugins.views.search.export.ExportMessagesCommand;
import org.graylog.plugins.views.search.export.SimpleMessage;
import org.graylog.plugins.views.search.export.SimpleMessageChunk;
import org.graylog.plugins.views.search.searchfilters.db.UsedSearchFiltersToQueryStringsMapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.IndicesOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.BoolQueryBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.TermsQueryBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.SearchHit;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.storage.elasticsearch7.TimeRangeQueryFactory;
import org.graylog.storage.elasticsearch7.views.export.RequestStrategy;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchExportBackend
implements ExportBackend {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchExportBackend.class);
    private final IndexLookup indexLookup;
    private final RequestStrategy requestStrategy;
    private final boolean allowLeadingWildcard;
    private final UsedSearchFiltersToQueryStringsMapper usedSearchFiltersToQueryStringsMapper;

    @Inject
    public ElasticsearchExportBackend(IndexLookup indexLookup, RequestStrategy requestStrategy, @Named(value="allow_leading_wildcard_searches") boolean allowLeadingWildcard, UsedSearchFiltersToQueryStringsMapper usedSearchFiltersToQueryStringsMapper) {
        this.indexLookup = indexLookup;
        this.requestStrategy = requestStrategy;
        this.allowLeadingWildcard = allowLeadingWildcard;
        this.usedSearchFiltersToQueryStringsMapper = usedSearchFiltersToQueryStringsMapper;
    }

    public void run(ExportMessagesCommand command, Consumer<SimpleMessageChunk> chunkCollector) {
        boolean isFirstChunk = true;
        int totalCount = 0;
        while (true) {
            List<SearchHit> hits;
            if ((hits = this.search(command)).isEmpty()) {
                this.publishChunk(chunkCollector, hits, command.fieldsInOrder(), command.timeZone(), SimpleMessageChunk.ChunkOrder.LAST);
                return;
            }
            boolean success = this.publishChunk(chunkCollector, hits, command.fieldsInOrder(), command.timeZone(), isFirstChunk ? SimpleMessageChunk.ChunkOrder.FIRST : SimpleMessageChunk.ChunkOrder.INTERMEDIATE);
            if (!success) {
                return;
            }
            if (command.limit().isPresent() && (totalCount += hits.size()) >= command.limit().getAsInt()) {
                LOG.info("Limit of {} reached. Stopping message retrieval.", (Object)command.limit().getAsInt());
                this.publishChunk(chunkCollector, Collections.emptyList(), command.fieldsInOrder(), command.timeZone(), SimpleMessageChunk.ChunkOrder.LAST);
                return;
            }
            isFirstChunk = false;
        }
    }

    private List<SearchHit> search(ExportMessagesCommand command) {
        SearchRequest search = this.prepareSearchRequest(command);
        return this.requestStrategy.nextChunk(search, command);
    }

    private SearchRequest prepareSearchRequest(ExportMessagesCommand command) {
        SearchSourceBuilder ssb = this.searchSourceBuilderFrom(command);
        Set<String> indices = this.indicesFor(command);
        return new SearchRequest().source(ssb).indices(indices.toArray(new String[0])).indicesOptions(IndicesOptions.fromOptions(false, false, true, false));
    }

    private SearchSourceBuilder searchSourceBuilderFrom(ExportMessagesCommand command) {
        QueryBuilder query = this.queryFrom(command);
        SearchSourceBuilder ssb = new SearchSourceBuilder().query(query).size(command.chunkSize());
        if (!command.exportAllFields()) {
            ssb = ssb.fetchSource(command.fieldsInOrder().toArray(new String[0]), null);
        }
        return this.requestStrategy.configure(ssb);
    }

    private QueryBuilder queryFrom(ExportMessagesCommand command) {
        Collection usedSearchFilters;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().filter(this.queryStringFilter(command.queryString())).filter(this.timestampFilter(command)).filter(this.streamsFilter(command));
        List attributeFilters = command.attributeFilters();
        if (attributeFilters != null && !attributeFilters.isEmpty()) {
            attributeFilters.stream().flatMap(attribute -> attribute.toQueryStrings().stream()).forEach(filterQuery -> boolQueryBuilder.filter(QueryBuilders.queryStringQuery(filterQuery)));
        }
        if ((usedSearchFilters = command.usedSearchFilters()) != null) {
            this.usedSearchFiltersToQueryStringsMapper.map(usedSearchFilters).forEach(filterQueryString -> boolQueryBuilder.filter(this.queryStringFilter((String)filterQueryString)));
        }
        return boolQueryBuilder;
    }

    private QueryBuilder queryStringFilter(ElasticsearchQueryString backendQuery) {
        return backendQuery.isEmpty() ? QueryBuilders.matchAllQuery() : QueryBuilders.queryStringQuery(backendQuery.queryString()).allowLeadingWildcard(this.allowLeadingWildcard);
    }

    private QueryBuilder queryStringFilter(String queryString) {
        ElasticsearchQueryString backendQuery = ElasticsearchQueryString.of((String)queryString);
        return this.queryStringFilter(backendQuery);
    }

    private QueryBuilder timestampFilter(ExportMessagesCommand command) {
        return Objects.requireNonNull(TimeRangeQueryFactory.create((TimeRange)command.timeRange()));
    }

    private TermsQueryBuilder streamsFilter(ExportMessagesCommand command) {
        return QueryBuilders.termsQuery("streams", command.streams());
    }

    private Set<String> indicesFor(ExportMessagesCommand command) {
        return this.indexLookup.indexNamesForStreamsInTimeRange((Collection)command.streams(), (TimeRange)command.timeRange());
    }

    private boolean publishChunk(Consumer<SimpleMessageChunk> chunkCollector, List<SearchHit> hits, LinkedHashSet<String> desiredFieldsInOrder, DateTimeZone timeZone, SimpleMessageChunk.ChunkOrder chunkOrder) {
        SimpleMessageChunk chunk = this.chunkFrom(hits, desiredFieldsInOrder, timeZone, chunkOrder);
        try {
            chunkCollector.accept(chunk);
            return true;
        }
        catch (Exception e) {
            LOG.warn("Chunk publishing threw exception. Stopping search after queries", (Throwable)e);
            return false;
        }
    }

    private SimpleMessageChunk chunkFrom(List<SearchHit> hits, LinkedHashSet<String> desiredFieldsInOrder, DateTimeZone timeZone, SimpleMessageChunk.ChunkOrder chunkOrder) {
        LinkedHashSet<SimpleMessage> messages = this.messagesFrom(hits, timeZone);
        return SimpleMessageChunk.builder().fieldsInOrder(desiredFieldsInOrder).messages(messages).chunkOrder(chunkOrder).build();
    }

    private LinkedHashSet<SimpleMessage> messagesFrom(List<SearchHit> hits, DateTimeZone timeZone) {
        return hits.stream().map(h -> this.buildHitWithAllFields(h.getSourceAsMap(), h.getIndex(), timeZone)).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

