/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7.views.migrations;

import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.graylog.plugins.views.migrations.V20200730000000_AddGl2MessageIdFieldAliasForEvents;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.IndicesOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.RequestOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.indices.PutMappingRequest;
import org.graylog.storage.elasticsearch7.ElasticsearchClient;
import org.graylog2.indexer.ElasticsearchException;

public class V20200730000000_AddGl2MessageIdFieldAliasForEventsES7
implements V20200730000000_AddGl2MessageIdFieldAliasForEvents.ElasticsearchAdapter {
    private final ElasticsearchClient client;

    @Inject
    public V20200730000000_AddGl2MessageIdFieldAliasForEventsES7(ElasticsearchClient client) {
        this.client = client;
    }

    public void addGl2MessageIdFieldAlias(Set<String> indexPrefixes) {
        String[] prefixesWithWildcard = (String[])indexPrefixes.stream().map(p -> p + "*").toArray(String[]::new);
        PutMappingRequest putMappingRequest = new PutMappingRequest(prefixesWithWildcard).indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED).source((Map<String, ?>)ImmutableMap.of((Object)"properties", (Object)ImmutableMap.of((Object)"gl2_message_id", V20200730000000_AddGl2MessageIdFieldAliasForEventsES7.aliasMapping())));
        try {
            AcknowledgedResponse acknowledgedResponse = this.client.execute((c, requestOptions) -> c.indices().putMapping(putMappingRequest, (RequestOptions)requestOptions));
            if (!acknowledgedResponse.isAcknowledged()) {
                throw new ElasticsearchException(this.errorMsgFor(prefixesWithWildcard) + " Elasticsearch failed to acknowledge.");
            }
        }
        catch (ElasticsearchException e) {
            throw new ElasticsearchException(this.errorMsgFor(prefixesWithWildcard), (Throwable)e);
        }
    }

    private String errorMsgFor(String[] prefixesWithWildcard) {
        return "Failed to add field alias gl2_message_id for indices " + Arrays.toString(prefixesWithWildcard) + ".";
    }

    static LinkedHashMap<String, Object> aliasMapping() {
        LinkedHashMap<String, Object> aliasMapping = new LinkedHashMap<String, Object>();
        aliasMapping.put("type", "alias");
        aliasMapping.put("path", "id");
        return aliasMapping;
    }
}

