/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7.views.searchtypes;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.graylog.events.event.EventDto;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.searchtypes.events.EventList;
import org.graylog.plugins.views.search.searchtypes.events.EventSummary;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.BoolQueryBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.SearchHit;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregations;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.sort.FieldSortBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.sort.SortOrder;
import org.graylog.storage.elasticsearch7.views.ESGeneratedQueryContext;
import org.graylog.storage.elasticsearch7.views.searchtypes.ESSearchTypeHandler;

public class ESEventList
implements ESSearchTypeHandler<EventList> {
    private final ObjectMapper objectMapper;

    @Inject
    public ESEventList(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void doGenerateQueryPart(Query query, EventList eventList, ESGeneratedQueryContext queryContext) {
        BoolQueryBuilder boolQueryBuilder;
        Set effectiveStreams = eventList.streams().isEmpty() ? query.usedStreamIds() : eventList.streams();
        SearchSourceBuilder searchSourceBuilder = queryContext.searchSourceBuilder((SearchType)eventList);
        FieldSortBuilder sortConfig = this.sortConfig(eventList);
        searchSourceBuilder.sort(sortConfig);
        QueryBuilder queryBuilder = searchSourceBuilder.query();
        if (!effectiveStreams.isEmpty() && queryBuilder instanceof BoolQueryBuilder) {
            boolQueryBuilder = (BoolQueryBuilder)queryBuilder;
            boolQueryBuilder.must(QueryBuilders.termsQuery("source_streams", effectiveStreams));
        }
        if (!eventList.attributes().isEmpty() && queryBuilder instanceof BoolQueryBuilder) {
            boolQueryBuilder = (BoolQueryBuilder)queryBuilder;
            List filterQueries = eventList.attributes().stream().filter(attribute -> EventList.KNOWN_ATTRIBUTES.contains(attribute.field())).flatMap(attribute -> attribute.toQueryStrings().stream()).toList();
            filterQueries.forEach(filterQuery -> boolQueryBuilder.filter(QueryBuilders.queryStringQuery(filterQuery)));
        }
        eventList.page().ifPresentOrElse(page -> {
            int pageSize = eventList.perPage().orElse(10);
            searchSourceBuilder.size(pageSize);
            searchSourceBuilder.from((page - 1) * pageSize);
        }, () -> searchSourceBuilder.size(10000));
    }

    private SortOrder toSortOrder(EventList.Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case EventList.Direction.ASC -> SortOrder.ASC;
            case EventList.Direction.DESC -> SortOrder.DESC;
        };
    }

    protected FieldSortBuilder sortConfig(EventList eventList) {
        EventList.SortConfig sortConfig = eventList.sort().filter(sort -> EventList.KNOWN_ATTRIBUTES.contains(sort.field())).orElse(EventList.DEFAULT_SORT);
        return (FieldSortBuilder)new FieldSortBuilder(sortConfig.field()).order(this.toSortOrder(sortConfig.direction()));
    }

    protected List<Map<String, Object>> extractResult(SearchResponse result) {
        return StreamSupport.stream(result.getHits().spliterator(), false).map(SearchHit::getSourceAsMap).collect(Collectors.toList());
    }

    @Override
    @WithSpan
    public SearchType.Result doExtractResult(SearchJob job, Query query, EventList searchType, SearchResponse result, Aggregations aggregations, ESGeneratedQueryContext queryContext) {
        Set effectiveStreams = searchType.streams().isEmpty() ? query.usedStreamIds() : searchType.streams();
        List eventSummaries = this.extractResult(result).stream().map(rawEvent -> (EventDto)this.objectMapper.convertValue(rawEvent, EventDto.class)).map(EventSummary::parse).collect(Collectors.toList());
        EventList.Result.Builder resultBuilder = EventList.Result.builder().events(eventSummaries).id(searchType.id()).totalResults(result.getHits().getTotalHits().value);
        searchType.name().ifPresent(arg_0 -> ((EventList.Result.Builder)resultBuilder).name(arg_0));
        return resultBuilder.build();
    }
}

