/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7.views.searchtypes;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Multimap;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.graylog.plugins.views.search.LegacyDecoratorProcessor;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.searchtypes.MessageList;
import org.graylog.plugins.views.search.searchtypes.Sort;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.text.Text;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.SearchHit;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregations;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.sort.FieldSortBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.sort.SortBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.sort.SortOrder;
import org.graylog.storage.elasticsearch7.views.ESGeneratedQueryContext;
import org.graylog.storage.elasticsearch7.views.searchtypes.ESSearchTypeHandler;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.indexer.results.ResultMessageFactory;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.rest.models.messages.responses.ResultMessageSummary;
import org.joda.time.DateTime;

public class ESMessageList
implements ESSearchTypeHandler<MessageList> {
    private final LegacyDecoratorProcessor decoratorProcessor;
    private final ResultMessageFactory resultMessageFactory;
    private final boolean allowHighlighting;

    @Inject
    public ESMessageList(LegacyDecoratorProcessor decoratorProcessor, ResultMessageFactory resultMessageFactory, @Named(value="allow_highlighting") boolean allowHighlighting) {
        this.decoratorProcessor = decoratorProcessor;
        this.resultMessageFactory = resultMessageFactory;
        this.allowHighlighting = allowHighlighting;
    }

    private ResultMessage resultMessageFromSearchHit(SearchHit hit) {
        Map<String, List> highlights = hit.getHighlightFields().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, ESMessageList::highlightsFromFragments));
        return this.resultMessageFactory.parseFromSource(hit.getId(), hit.getIndex(), hit.getSourceAsMap(), highlights);
    }

    private static List<String> highlightsFromFragments(Map.Entry<String, HighlightField> entry) {
        return Arrays.stream(entry.getValue().fragments()).map(Text::toString).collect(Collectors.toList());
    }

    public void doGenerateQueryPart(Query query, MessageList messageList, ESGeneratedQueryContext queryContext) {
        SearchSourceBuilder searchSourceBuilder = queryContext.searchSourceBuilder((SearchType)messageList).size(messageList.limit()).from(messageList.offset());
        this.applyHighlightingIfActivated(searchSourceBuilder, query);
        Set effectiveStreamIds = query.effectiveStreams((SearchType)messageList);
        if (!messageList.fields().isEmpty()) {
            searchSourceBuilder.fetchSource(messageList.fields().toArray(new String[0]), new String[0]);
        }
        ArrayList<Sort> sorts = (ArrayList<Sort>)MoreObjects.firstNonNull((Object)messageList.sort(), Collections.singletonList(Sort.create((String)"timestamp", (Sort.Order)Sort.Order.DESC)));
        Optional<Sort> timeStampSort = ESMessageList.findSort((List<Sort>)sorts, "timestamp");
        Optional<Sort> msgIdSort = ESMessageList.findSort((List<Sort>)sorts, "gl2_message_id");
        Optional<Sort> secondSortField = ESMessageList.findSort((List<Sort>)sorts, "gl2_second_sort_field");
        if (timeStampSort.isPresent() && msgIdSort.isEmpty() && secondSortField.isEmpty()) {
            sorts = new ArrayList<Sort>(sorts);
            Sort newMsgIdSort = Sort.create((String)"gl2_second_sort_field", (Sort.Order)timeStampSort.get().order());
            sorts.add(sorts.indexOf(timeStampSort.get()) + 1, newMsgIdSort);
        }
        sorts.forEach(sort -> {
            FieldSortBuilder fieldSort = (FieldSortBuilder)SortBuilders.fieldSort(sort.field()).order(this.toSortOrder(sort.order()));
            if (sort.field().equals("gl2_second_sort_field")) {
                fieldSort.unmappedType("keyword");
                searchSourceBuilder.sort(fieldSort);
            } else {
                Optional<String> fieldType = queryContext.fieldType(effectiveStreamIds, sort.field());
                searchSourceBuilder.sort(fieldType.map(fieldSort::unmappedType).orElse(fieldSort));
            }
        });
    }

    private static Optional<Sort> findSort(List<Sort> sorts, String search) {
        return sorts.stream().filter(s -> s.field().equals(search)).findFirst();
    }

    private SortOrder toSortOrder(Sort.Order sortOrder) {
        switch (sortOrder) {
            case ASC: {
                return SortOrder.ASC;
            }
            case DESC: {
                return SortOrder.DESC;
            }
        }
        throw new IllegalStateException("Invalid sort order: " + String.valueOf(sortOrder));
    }

    private void applyHighlightingIfActivated(SearchSourceBuilder searchSourceBuilder, Query query) {
        if (!this.allowHighlighting) {
            return;
        }
        QueryStringQueryBuilder highlightQuery = this.decoratedHighlightQuery(query);
        searchSourceBuilder.highlighter((HighlightBuilder)((HighlightBuilder)((HighlightBuilder)((HighlightBuilder)new HighlightBuilder().requireFieldMatch(false)).highlightQuery(highlightQuery)).field("*").fragmentSize(0)).numOfFragments(0));
    }

    private QueryStringQueryBuilder decoratedHighlightQuery(Query query) {
        String queryString = query.query().queryString();
        return QueryBuilders.queryStringQuery(queryString);
    }

    @Override
    @WithSpan
    public SearchType.Result doExtractResult(SearchJob job, Query query, MessageList searchType, SearchResponse result, Aggregations aggregations, ESGeneratedQueryContext queryContext) {
        List messages = StreamSupport.stream(result.getHits().spliterator(), false).map(this::resultMessageFromSearchHit).map(resultMessage -> ResultMessageSummary.create((Multimap)resultMessage.highlightRanges, (Map)resultMessage.getMessage().getFields(), (String)resultMessage.getIndex())).collect(Collectors.toList());
        String queryString = query.query().queryString();
        DateTime from = query.effectiveTimeRange((SearchType)searchType).getFrom();
        DateTime to = query.effectiveTimeRange((SearchType)searchType).getTo();
        org.graylog2.rest.resources.search.responses.SearchResponse searchResponse = org.graylog2.rest.resources.search.responses.SearchResponse.create((String)queryString, (String)queryString, Collections.emptySet(), messages, Collections.emptySet(), (long)0L, (long)result.getHits().getTotalHits().value, (DateTime)from, (DateTime)to);
        org.graylog2.rest.resources.search.responses.SearchResponse decoratedSearchResponse = this.decoratorProcessor.decorateSearchResponse(searchResponse, searchType.decorators());
        MessageList.Result.Builder resultBuilder = MessageList.Result.result((String)searchType.id()).messages(decoratedSearchResponse.messages()).effectiveTimerange(AbsoluteRange.create((DateTime)from, (DateTime)to)).totalResults(decoratedSearchResponse.totalResults());
        return searchType.name().map(arg_0 -> ((MessageList.Result.Builder)resultBuilder).name(arg_0)).orElse(resultBuilder).build();
    }
}

