/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7.views.searchtypes.pivot;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.searchtypes.pivot.BucketSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.BucketSpecHandler;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotSort;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSort;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.SortSpec;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.BucketOrder;
import org.graylog.storage.elasticsearch7.views.ESGeneratedQueryContext;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.AggTypes;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.PivotBucket;

public abstract class ESPivotBucketSpecHandler<SPEC_TYPE extends BucketSpec>
implements BucketSpecHandler<SPEC_TYPE, AggregationBuilder, ESGeneratedQueryContext> {
    protected AggTypes aggTypes(ESGeneratedQueryContext queryContext, Pivot pivot) {
        return (AggTypes)queryContext.contextMap().get(pivot.id());
    }

    protected void record(ESGeneratedQueryContext queryContext, Pivot pivot, PivotSpec spec, String name, Class<? extends Aggregation> aggregationClass) {
        this.aggTypes(queryContext, pivot).record(spec, name, aggregationClass);
    }

    protected SortOrders orderListForPivot(Pivot pivot, ESGeneratedQueryContext esGeneratedQueryContext, BucketOrder defaultOrder, Query query) {
        ArrayList sortingAggregations = new ArrayList();
        List<BucketOrder> ordering = pivot.sort().stream().map(sortSpec -> {
            boolean isAscending = sortSpec.direction().equals((Object)SortSpec.Direction.Ascending);
            if (sortSpec instanceof PivotSort) {
                PivotSort pivotSort = (PivotSort)sortSpec;
                if (this.isSortOnNumericPivotField(pivot, pivotSort, esGeneratedQueryContext, query)) {
                    String aggregationName = "sort_helper" + pivotSort.field();
                    sortingAggregations.add(AggregationBuilders.max(aggregationName).field(pivotSort.field()));
                    return BucketOrder.aggregation(aggregationName, isAscending);
                }
                return BucketOrder.key(isAscending);
            }
            if (sortSpec instanceof SeriesSort) {
                Optional<SeriesSpec> matchingSeriesSpec = pivot.series().stream().filter(series -> series.literal().equals(sortSpec.field())).findFirst();
                return matchingSeriesSpec.map(seriesSpec -> {
                    if (seriesSpec.literal().equals("count()")) {
                        return BucketOrder.count(isAscending);
                    }
                    String orderPath = seriesSpec.statsSubfieldName().map(subField -> esGeneratedQueryContext.seriesName((SeriesSpec)seriesSpec, pivot) + "." + subField).orElse(esGeneratedQueryContext.seriesName((SeriesSpec)seriesSpec, pivot));
                    return BucketOrder.aggregation(orderPath, isAscending);
                }).orElse(null);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return ordering.isEmpty() ? new SortOrders(List.of(defaultOrder), List.of()) : new SortOrders(ordering, List.copyOf(sortingAggregations));
    }

    private boolean isSortOnNumericPivotField(Pivot pivot, PivotSort pivotSort, ESGeneratedQueryContext queryContext, Query query) {
        return queryContext.fieldType(query.effectiveStreams((SearchType)pivot), pivotSort.field()).filter(this::isNumericFieldType).isPresent();
    }

    private boolean isNumericFieldType(String fieldType) {
        return fieldType.equals("long") || fieldType.equals("double") || fieldType.equals("float");
    }

    public abstract Stream<PivotBucket> extractBuckets(Pivot var1, BucketSpec var2, PivotBucket var3);

    public record SortOrders(List<BucketOrder> orders, List<AggregationBuilder> sortingAggregations) {
    }
}

