/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7.views.searchtypes.pivot;

import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.Max;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.Min;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EffectiveTimeRangeExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(EffectiveTimeRangeExtractor.class);
    private static final TimeRange ALL_MESSAGES_TIMERANGE = EffectiveTimeRangeExtractor.allMessagesTimeRange();

    private static TimeRange allMessagesTimeRange() {
        try {
            return RelativeRange.create((int)0);
        }
        catch (InvalidRangeParametersException e) {
            LOG.error("Unable to instantiate all messages timerange: ", (Throwable)e);
            return null;
        }
    }

    AbsoluteRange extract(SearchResponse queryResult, Query query, Pivot pivot) {
        if (queryResult.getHits().getTotalHits().value != 0L) {
            return this.getAbsoluteRangeFromAggregations(queryResult, query, pivot);
        }
        return this.getAbsoluteRangeFromPivot(query, pivot);
    }

    private AbsoluteRange getAbsoluteRangeFromPivot(Query query, Pivot pivot) {
        TimeRange pivotRange = query.effectiveTimeRange((SearchType)pivot);
        return AbsoluteRange.create((DateTime)pivotRange.getFrom(), (DateTime)pivotRange.getTo());
    }

    private AbsoluteRange getAbsoluteRangeFromAggregations(SearchResponse queryResult, Query query, Pivot pivot) {
        Min min = (Min)queryResult.getAggregations().get("timestamp-min");
        Double from = min.getValue();
        Max max = (Max)queryResult.getAggregations().get("timestamp-max");
        Double to = max.getValue();
        TimeRange pivotRange = query.effectiveTimeRange((SearchType)pivot);
        return AbsoluteRange.create((DateTime)(this.isAllMessagesTimeRange(pivotRange) && from != 0.0 ? new DateTime(from.longValue(), DateTimeZone.UTC) : pivotRange.getFrom()), (DateTime)(this.isAllMessagesTimeRange(pivotRange) && to != 0.0 ? new DateTime(to.longValue(), DateTimeZone.UTC) : pivotRange.getTo()));
    }

    private boolean isAllMessagesTimeRange(TimeRange timeRange) {
        return ALL_MESSAGES_TIMERANGE.equals(timeRange);
    }
}

