/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7.views.searchtypes.pivot.buckets;

import com.google.common.collect.ImmutableList;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.searchtypes.pivot.BucketSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.BucketSpecHandler;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.buckets.DateRangeBucket;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.range.DateRangeAggregationBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.range.ParsedDateRange;
import org.graylog.storage.elasticsearch7.views.ESGeneratedQueryContext;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.ESPivotBucketSpecHandler;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.PivotBucket;
import org.joda.time.base.AbstractDateTime;

public class ESDateRangeHandler
extends ESPivotBucketSpecHandler<DateRangeBucket> {
    private static final String AGG_NAME = "agg";

    @Nonnull
    public BucketSpecHandler.CreatedAggregations<AggregationBuilder> doCreateAggregation(BucketSpecHandler.Direction direction, String name, Pivot pivot, DateRangeBucket dateRangeBucket, ESGeneratedQueryContext queryContext, Query query) {
        DateRangeAggregationBuilder root = null;
        AggregationBuilder leaf = null;
        for (String dateRangeField : dateRangeBucket.fields()) {
            DateRangeAggregationBuilder builder = (DateRangeAggregationBuilder)AggregationBuilders.dateRange(name).field(dateRangeField);
            dateRangeBucket.ranges().forEach(r -> {
                String from = r.from().map(AbstractDateTime::toString).orElse(null);
                String to = r.to().map(AbstractDateTime::toString).orElse(null);
                if (from != null && to != null) {
                    builder.addRange(from, to);
                } else if (to != null) {
                    builder.addUnboundedTo(to);
                } else if (from != null) {
                    builder.addUnboundedFrom(from);
                }
            });
            builder.format("date_time");
            builder.keyed(false);
            this.record(queryContext, pivot, (PivotSpec)dateRangeBucket, name, ParsedDateRange.class);
            if (root == null && leaf == null) {
                root = builder;
                leaf = builder;
                continue;
            }
            leaf.subAggregation(builder);
            leaf = builder;
        }
        return BucketSpecHandler.CreatedAggregations.create(root, leaf);
    }

    @Override
    public Stream<PivotBucket> extractBuckets(Pivot pivot, BucketSpec bucketSpec, PivotBucket initialBucket) {
        ImmutableList<String> previousKeys = initialBucket.keys();
        MultiBucketsAggregation.Bucket previousBucket = initialBucket.bucket();
        ParsedDateRange aggregation = (ParsedDateRange)previousBucket.getAggregations().get(AGG_NAME);
        DateRangeBucket dateRangeBucket = (DateRangeBucket)bucketSpec;
        return aggregation.getBuckets().stream().flatMap(bucket -> {
            String bucketKey = dateRangeBucket.bucketKey().equals((Object)DateRangeBucket.BucketKey.TO) ? bucket.getToAsString() : bucket.getFromAsString();
            ImmutableList keys = ImmutableList.builder().addAll((Iterable)previousKeys).add((Object)bucketKey).build();
            return Stream.of(PivotBucket.create((ImmutableList<String>)keys, bucket, false));
        });
    }
}

