/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7.views.searchtypes.pivot.buckets;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.searchtypes.pivot.BucketSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.BucketSpecHandler;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.buckets.AutoInterval;
import org.graylog.plugins.views.search.searchtypes.pivot.buckets.Interval;
import org.graylog.plugins.views.search.searchtypes.pivot.buckets.Time;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.BucketOrder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.histogram.AutoDateHistogramAggregationBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.graylog.storage.elasticsearch7.views.ESGeneratedQueryContext;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.ESPivotBucketSpecHandler;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.PivotBucket;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

public class ESTimeHandler
extends ESPivotBucketSpecHandler<Time> {
    private static final String AGG_NAME = "agg";
    private static final BucketOrder defaultOrder = BucketOrder.key(true);
    private static final int BASE_NUM_BUCKETS = 25;
    public static final String DATE_TIME_FORMAT = "date_time";

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Nonnull
    public BucketSpecHandler.CreatedAggregations<AggregationBuilder> doCreateAggregation(BucketSpecHandler.Direction direction, String name, Pivot pivot, Time timeSpec, ESGeneratedQueryContext queryContext, Query query) {
        void var7_12;
        Iterator iterator;
        Interval interval;
        AggregationBuilder leaf;
        block6: {
            Iterator iterator2;
            AutoInterval autoInterval;
            block5: {
                block4: {
                    Object var7_7 = null;
                    leaf = null;
                    interval = timeSpec.interval();
                    TimeRange timerange = query.timerange();
                    if (!(interval instanceof AutoInterval)) break block4;
                    autoInterval = (AutoInterval)interval;
                    if (!this.isAllMessages(timerange)) break block4;
                    iterator2 = timeSpec.fields().iterator();
                    break block5;
                }
                iterator = timeSpec.fields().iterator();
                break block6;
            }
            while (iterator2.hasNext()) {
                void var7_8;
                String timeField = (String)iterator2.next();
                AutoDateHistogramAggregationBuilder builder = (AutoDateHistogramAggregationBuilder)((AutoDateHistogramAggregationBuilder)new AutoDateHistogramAggregationBuilder(name).field(timeField)).setNumBuckets((int)(25.0 / autoInterval.scaling())).format(DATE_TIME_FORMAT);
                if (var7_8 == null && leaf == null) {
                    AutoDateHistogramAggregationBuilder autoDateHistogramAggregationBuilder = builder;
                    leaf = builder;
                    continue;
                }
                leaf.subAggregation(builder);
                leaf = builder;
            }
            return BucketSpecHandler.CreatedAggregations.create((Object)var7_12, leaf);
        }
        while (iterator.hasNext()) {
            void var7_10;
            String timeField = (String)iterator.next();
            DateHistogramInterval dateHistogramInterval = new DateHistogramInterval(interval.toDateInterval(query.effectiveTimeRange((SearchType)pivot)).toString());
            ESPivotBucketSpecHandler.SortOrders ordering = this.orderListForPivot(pivot, queryContext, defaultOrder, query);
            DateHistogramAggregationBuilder builder = (DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram(name).field(timeField)).order(ordering.orders()).format(DATE_TIME_FORMAT);
            this.setInterval(builder, dateHistogramInterval);
            if (var7_10 == null && leaf == null) {
                DateHistogramAggregationBuilder dateHistogramAggregationBuilder = builder;
                leaf = builder;
                continue;
            }
            leaf.subAggregation(builder);
            leaf = builder;
        }
        return BucketSpecHandler.CreatedAggregations.create((Object)var7_12, leaf);
    }

    private boolean isAllMessages(TimeRange timerange) {
        return timerange instanceof RelativeRange && ((RelativeRange)timerange).isAllMessages();
    }

    private void setInterval(DateHistogramAggregationBuilder builder, DateHistogramInterval interval) {
        if (DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(interval.toString()) != null) {
            builder.calendarInterval(interval);
        } else {
            builder.fixedInterval(interval);
        }
    }

    @Override
    public Stream<PivotBucket> extractBuckets(Pivot pivot, BucketSpec bucketSpec, PivotBucket initialBucket) {
        ImmutableList<String> previousKeys = initialBucket.keys();
        MultiBucketsAggregation.Bucket previousBucket = initialBucket.bucket();
        MultiBucketsAggregation aggregation = (MultiBucketsAggregation)previousBucket.getAggregations().get(AGG_NAME);
        return aggregation.getBuckets().stream().flatMap(bucket -> {
            ImmutableList keys = ImmutableList.builder().addAll((Iterable)previousKeys).add((Object)bucket.getKeyAsString()).build();
            return Stream.of(PivotBucket.create((ImmutableList<String>)keys, bucket, false));
        });
    }
}

