/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7.views.searchtypes.pivot.buckets;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.searchtypes.pivot.BucketSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.BucketSpecHandler;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotSort;
import org.graylog.plugins.views.search.searchtypes.pivot.SortSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.buckets.Values;
import org.graylog.plugins.views.search.searchtypes.pivot.buckets.ValuesBucketOrdering;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.BoolQueryBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.Script;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.BucketOrder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.filter.Filters;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregationBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.filter.ParsedFilters;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.graylog.storage.elasticsearch7.views.ESGeneratedQueryContext;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.ESPivotBucketSpecHandler;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.PivotBucket;

public class ESValuesHandler
extends ESPivotBucketSpecHandler<Values> {
    private static final String KEY_SEPARATOR_CHARACTER = "\u2e31";
    private static final String KEY_SEPARATOR_PHRASE = " + \"\u2e31\" + ";
    private static final String AGG_NAME = "agg";
    public static final BucketOrder DEFAULT_ORDER = BucketOrder.count(false);
    public static final String SORT_HELPER = "sort_helper";

    @Nonnull
    public BucketSpecHandler.CreatedAggregations<AggregationBuilder> doCreateAggregation(BucketSpecHandler.Direction direction, String name, Pivot pivot, Values bucketSpec, ESGeneratedQueryContext queryContext, Query query) {
        ESPivotBucketSpecHandler.SortOrders ordering = this.orderListForPivot(pivot, queryContext, DEFAULT_ORDER, query);
        int limit = bucketSpec.limit();
        List orderedBuckets = ValuesBucketOrdering.orderFields((List)bucketSpec.fields(), (List)pivot.sort());
        TermsAggregationBuilder termsAggregation = this.createTerms(orderedBuckets, limit);
        termsAggregation.order(ordering.orders());
        ordering.sortingAggregations().forEach(termsAggregation::subAggregation);
        FiltersAggregationBuilder filterAggregation = (FiltersAggregationBuilder)this.createFilter(name, orderedBuckets, bucketSpec.skipEmptyValues()).subAggregation(termsAggregation);
        return BucketSpecHandler.CreatedAggregations.create((Object)filterAggregation, (Object)termsAggregation, List.of(termsAggregation, filterAggregation));
    }

    private FiltersAggregationBuilder createFilter(String name, List<String> fields, boolean skipEmptyValues) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        fields.stream().map(QueryBuilders::existsQuery).forEach(skipEmptyValues ? queryBuilder::must : queryBuilder::should);
        return AggregationBuilders.filters(name, queryBuilder).otherBucket(true);
    }

    private TermsAggregationBuilder createTerms(List<String> valueBuckets, int limit) {
        return this.createScriptedTerms(valueBuckets, limit);
    }

    private TermsAggregationBuilder createScriptedTerms(List<String> buckets, int limit) {
        return ((TermsAggregationBuilder)AggregationBuilders.terms(AGG_NAME).script(this.scriptForPivots(buckets))).size(limit);
    }

    private Script scriptForPivots(Collection<String> pivots) {
        String scriptSource = Joiner.on((String)KEY_SEPARATOR_PHRASE).join((Iterable)pivots.stream().map(bucket -> "(doc.containsKey('%1$s') && doc['%1$s'].size() > 0\n? doc['%1$s'].size() > 1\n    ? doc['%1$s']\n    : String.valueOf(doc['%1$s'].value)\n: \"%2$s\")\n".formatted(bucket, "(Empty Value)")).collect(Collectors.toList()));
        return new Script(scriptSource);
    }

    private TermsAggregationBuilder applyOrdering(Pivot pivot, TermsAggregationBuilder terms, List<BucketOrder> ordering, ESGeneratedQueryContext queryContext) {
        return this.sortsOnNumericPivotField(pivot, queryContext).map(pivotSort -> ((TermsAggregationBuilder)terms.subAggregation((AggregationBuilder)AggregationBuilders.max(SORT_HELPER).field(pivotSort.field()))).order(BucketOrder.aggregation(SORT_HELPER, SortSpec.Direction.Ascending.equals((Object)pivotSort.direction())))).orElseGet(() -> terms.order(ordering.isEmpty() ? List.of(DEFAULT_ORDER) : ordering));
    }

    private Optional<PivotSort> sortsOnNumericPivotField(Pivot pivot, ESGeneratedQueryContext queryContext) {
        return Optional.ofNullable(pivot.sort()).filter(sorts -> sorts.size() == 1).map(sorts -> (SortSpec)sorts.get(0)).filter(sort -> sort instanceof PivotSort).map(sort -> (PivotSort)sort).filter(pivotSort -> queryContext.fieldType(pivot.effectiveStreams(), pivotSort.field()).filter(this::isNumericFieldType).isPresent());
    }

    private boolean isNumericFieldType(String fieldType) {
        return fieldType.equals("long") || fieldType.equals("double") || fieldType.equals("float");
    }

    @Override
    public Stream<PivotBucket> extractBuckets(Pivot pivot, BucketSpec bucketSpec, PivotBucket initialBucket) {
        Values values = (Values)bucketSpec;
        ImmutableList<String> previousKeys = initialBucket.keys();
        MultiBucketsAggregation.Bucket previousBucket = initialBucket.bucket();
        Function reorderKeys = ValuesBucketOrdering.reorderFieldsFunction((List)bucketSpec.fields(), (List)pivot.sort());
        Object aggregation = previousBucket.getAggregations().get(AGG_NAME);
        if (!(aggregation instanceof ParsedFilters)) {
            return Stream.of(initialBucket);
        }
        ParsedFilters filterAggregation = (ParsedFilters)aggregation;
        MultiBucketsAggregation termsAggregation = (MultiBucketsAggregation)filterAggregation.getBuckets().get(0).getAggregations().get(AGG_NAME);
        if (values.skipEmptyValues()) {
            return this.extractTermsBuckets(previousKeys, reorderKeys, termsAggregation);
        }
        Filters.Bucket otherBucket = filterAggregation.getBuckets().get(1);
        Stream<PivotBucket> bucketStream = this.extractTermsBuckets(previousKeys, reorderKeys, termsAggregation);
        if (otherBucket.getDocCount() > 0L) {
            MultiBucketsAggregation otherTermsAggregations = (MultiBucketsAggregation)otherBucket.getAggregations().get(AGG_NAME);
            Stream<PivotBucket> otherStream = this.extractTermsBuckets(previousKeys, reorderKeys, otherTermsAggregations);
            return Stream.concat(bucketStream, otherStream);
        }
        return bucketStream;
    }

    private Stream<PivotBucket> extractTermsBuckets(ImmutableList<String> previousKeys, Function<List<String>, List<String>> reorderKeys, MultiBucketsAggregation termsAggregation) {
        return termsAggregation.getBuckets().stream().map(bucket -> {
            ImmutableList keys = ImmutableList.builder().addAll((Iterable)previousKeys).addAll((Iterable)reorderKeys.apply((List<String>)this.splitKeys(bucket.getKeyAsString()))).build();
            return PivotBucket.create((ImmutableList<String>)keys, bucket, false);
        });
    }

    private ImmutableList<String> splitKeys(String keys) {
        return ImmutableList.copyOf((Iterable)Splitter.on((String)KEY_SEPARATOR_CHARACTER).split((CharSequence)keys));
    }
}

