/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7.views.searchtypes.pivot.series;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Latest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.SearchHit;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.SearchHits;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.filter.ParsedFilter;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.TopHits;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.sort.SortBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.sort.SortBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.sort.SortOrder;
import org.graylog.storage.elasticsearch7.views.ESGeneratedQueryContext;
import org.graylog.storage.elasticsearch7.views.searchtypes.ESSearchTypeHandler;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.ESPivotSeriesSpecHandler;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.SeriesAggregationBuilder;

public class ESLatestHandler
extends ESPivotSeriesSpecHandler<Latest, ParsedFilter> {
    private static final String AGG_NAME = "latest_aggregation";

    @Nonnull
    public List<SeriesAggregationBuilder> doCreateAggregation(String name, Pivot pivot, Latest latestSpec, ESSearchTypeHandler<Pivot> searchTypeHandler, ESGeneratedQueryContext queryContext) {
        FilterAggregationBuilder latest = (FilterAggregationBuilder)AggregationBuilders.filter(name, QueryBuilders.existsQuery(latestSpec.field())).subAggregation(AggregationBuilders.topHits(AGG_NAME).size(1).fetchSource(latestSpec.field(), null).sort((SortBuilder<?>)SortBuilders.fieldSort("timestamp").order(SortOrder.DESC)));
        this.record(queryContext, pivot, (PivotSpec)latestSpec, name, ParsedFilter.class);
        return List.of(SeriesAggregationBuilder.metric(latest));
    }

    @Override
    public Stream<ESPivotSeriesSpecHandler.Value> doHandleResult(Pivot pivot, Latest pivotSpec, SearchResponse searchResult, ParsedFilter filterAggregation, ESSearchTypeHandler<Pivot> searchTypeHandler, ESGeneratedQueryContext esGeneratedQueryContext) {
        TopHits latestAggregation = (TopHits)filterAggregation.getAggregations().get(AGG_NAME);
        Optional<ESPivotSeriesSpecHandler.Value> latestValue = Optional.ofNullable(latestAggregation).map(TopHits::getHits).map(SearchHits::getHits).filter(hits -> ((SearchHit[])hits).length > 0).map(hits -> hits[0]).map(SearchHit::getSourceAsMap).map(source -> source.get(pivotSpec.field())).map(value -> ESPivotSeriesSpecHandler.Value.create(pivotSpec.id(), "latest", value));
        return latestValue.stream();
    }
}

