/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7.views.searchtypes.pivot.series;

import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Count;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Percentage;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Sum;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregations;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.HasAggregations;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.ParsedSum;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.ValueCount;
import org.graylog.storage.elasticsearch7.views.ESGeneratedQueryContext;
import org.graylog.storage.elasticsearch7.views.searchtypes.ESSearchTypeHandler;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.ESPivotSeriesSpecHandler;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.InitialBucket;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.SeriesAggregationBuilder;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.series.ESCountHandler;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.series.ESSumHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESPercentageHandler
extends ESPivotSeriesSpecHandler<Percentage, ValueCount> {
    private static final Logger LOG = LoggerFactory.getLogger(ESCountHandler.class);
    private final ESCountHandler esCountHandler;
    private final ESSumHandler esSumHandler;

    @Inject
    public ESPercentageHandler(ESCountHandler esCountHandler, ESSumHandler esSumHandler) {
        this.esCountHandler = esCountHandler;
        this.esSumHandler = esSumHandler;
    }

    @Nonnull
    public List<SeriesAggregationBuilder> doCreateAggregation(String name, Pivot pivot, Percentage percentage, ESSearchTypeHandler<Pivot> searchTypeHandler, ESGeneratedQueryContext queryContext) {
        List<SeriesAggregationBuilder> aggregation = this.createNestedSeriesAggregation(name, pivot, percentage, searchTypeHandler, queryContext);
        return Stream.concat(aggregation.stream(), aggregation.stream().map(r -> SeriesAggregationBuilder.root(r.aggregationBuilder()))).toList();
    }

    private List<SeriesAggregationBuilder> createNestedSeriesAggregation(String name, Pivot pivot, Percentage percentage, ESSearchTypeHandler<Pivot> searchTypeHandler, ESGeneratedQueryContext queryContext) {
        return switch (percentage.strategy().orElse(Percentage.Strategy.COUNT)) {
            default -> throw new MatchException(null, null);
            case Percentage.Strategy.SUM -> {
                Sum.Builder seriesSpecBuilder = Sum.builder().id(percentage.id());
                Sum seriesSpec = percentage.field().map(arg_0 -> ((Sum.Builder)seriesSpecBuilder).field(arg_0)).orElse(seriesSpecBuilder).build();
                yield this.esSumHandler.createAggregation(name, pivot, (SeriesSpec)seriesSpec, searchTypeHandler, queryContext);
            }
            case Percentage.Strategy.COUNT -> {
                Count.Builder seriesSpecBuilder = Count.builder().id(percentage.id());
                Count seriesSpec = percentage.field().map(arg_0 -> ((Count.Builder)seriesSpecBuilder).field(arg_0)).orElse(seriesSpecBuilder).build();
                yield this.esCountHandler.createAggregation(name, pivot, (SeriesSpec)seriesSpec, searchTypeHandler, queryContext);
            }
        };
    }

    private Stream<ESPivotSeriesSpecHandler.Value> handleNestedSeriesResults(Pivot pivot, Percentage percentage, SearchResponse searchResult, Object seriesResult, ESSearchTypeHandler<Pivot> searchTypeHandler, ESGeneratedQueryContext esGeneratedQueryContext) {
        return switch (percentage.strategy().orElse(Percentage.Strategy.COUNT)) {
            default -> throw new MatchException(null, null);
            case Percentage.Strategy.SUM -> {
                Sum.Builder seriesSpecBuilder = Sum.builder().id(percentage.id());
                Sum seriesSpec = percentage.field().map(arg_0 -> ((Sum.Builder)seriesSpecBuilder).field(arg_0)).orElse(seriesSpecBuilder).build();
                yield this.esSumHandler.handleResult(pivot, (SeriesSpec)seriesSpec, searchResult, seriesResult, searchTypeHandler, esGeneratedQueryContext);
            }
            case Percentage.Strategy.COUNT -> {
                Count.Builder seriesSpecBuilder = Count.builder().id(percentage.id());
                Count seriesSpec = percentage.field().map(arg_0 -> ((Count.Builder)seriesSpecBuilder).field(arg_0)).orElse(seriesSpecBuilder).build();
                yield this.esCountHandler.handleResult(pivot, (SeriesSpec)seriesSpec, searchResult, seriesResult, searchTypeHandler, esGeneratedQueryContext);
            }
        };
    }

    @Override
    public Stream<ESPivotSeriesSpecHandler.Value> doHandleResult(Pivot pivot, Percentage percentage, SearchResponse searchResult, ValueCount valueCount, ESSearchTypeHandler<Pivot> searchTypeHandler, ESGeneratedQueryContext esGeneratedQueryContext) {
        long value;
        if (valueCount == null) {
            LOG.error("Unexpected null aggregation result, returning 0 for the count. This is a bug.");
            value = 0L;
        } else {
            value = valueCount instanceof MultiBucketsAggregation.Bucket ? ((MultiBucketsAggregation.Bucket)((Object)valueCount)).getDocCount() : (valueCount instanceof Aggregations ? searchResult.getHits().getTotalHits().value : valueCount.getValue());
        }
        MultiBucketsAggregation.Bucket initialBucket = esGeneratedQueryContext.rowBucket().orElseGet(() -> InitialBucket.create(searchResult));
        Aggregation rootResult = this.extractNestedSeriesAggregation(pivot, percentage, initialBucket, esGeneratedQueryContext);
        Stream<ESPivotSeriesSpecHandler.Value> nestedSeriesResult = this.handleNestedSeriesResults(pivot, percentage, searchResult, rootResult, searchTypeHandler, esGeneratedQueryContext);
        return nestedSeriesResult.map(result -> {
            Number totalResult = (Number)result.value();
            return (double)value / totalResult.doubleValue();
        }).map(bucketPercentage -> ESPivotSeriesSpecHandler.Value.create(percentage.id(), "percentage", bucketPercentage));
    }

    private Aggregation extractNestedSeriesAggregation(Pivot pivot, Percentage percentage, HasAggregations aggregations, ESGeneratedQueryContext queryContext) {
        return switch (percentage.strategy().orElse(Percentage.Strategy.COUNT)) {
            default -> throw new MatchException(null, null);
            case Percentage.Strategy.SUM -> {
                Sum.Builder seriesSpecBuilder = Sum.builder().id(percentage.id());
                Sum seriesSpec = percentage.field().map(arg_0 -> ((Sum.Builder)seriesSpecBuilder).field(arg_0)).orElse(seriesSpecBuilder).build();
                yield this.esSumHandler.extractAggregationFromResult(pivot, (PivotSpec)seriesSpec, aggregations, queryContext);
            }
            case Percentage.Strategy.COUNT -> {
                Count.Builder seriesSpecBuilder = Count.builder().id(percentage.id());
                Count seriesSpec = percentage.field().map(arg_0 -> ((Count.Builder)seriesSpecBuilder).field(arg_0)).orElse(seriesSpecBuilder).build();
                yield this.esCountHandler.extractAggregationFromResult(pivot, (PivotSpec)seriesSpec, aggregations, queryContext);
            }
        };
    }

    @Override
    public Aggregation extractAggregationFromResult(Pivot pivot, PivotSpec spec, HasAggregations aggregations, ESGeneratedQueryContext queryContext) {
        Aggregation result = this.extractNestedSeriesAggregation(pivot, (Percentage)spec, aggregations, queryContext);
        if (result instanceof ValueCount) {
            return result;
        }
        if (result instanceof ParsedSum) {
            ParsedSum sum = (ParsedSum)result;
            return this.createValueCount(sum.getValue());
        }
        throw new IllegalStateException("Unable to parse result: " + String.valueOf(result));
    }

    private Aggregation createValueCount(final Double value) {
        return new ValueCount(){

            @Override
            public long getValue() {
                return value.longValue();
            }

            @Override
            public double value() {
                return value;
            }

            @Override
            public String getValueAsString() {
                return value.toString();
            }

            @Override
            public String getName() {
                return null;
            }

            @Override
            public String getType() {
                return null;
            }

            @Override
            public Map<String, Object> getMetadata() {
                return null;
            }

            @Override
            public XContentBuilder toXContent(XContentBuilder xContentBuilder, ToXContent.Params params) {
                return null;
            }
        };
    }
}

